/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.logging;

import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.logging.EnhancedFileHandler;
import io.github.albertus82.util.logging.FileHandlerConfig;
import io.github.albertus82.util.logging.TimeBasedRollingFileHandlerConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TimeBasedRollingFileHandler
extends Handler {
    private final String fileNamePattern;
    private final String datePattern;
    private final DateFormat dateFormat;
    private final ISupplier<Date> dateSupplier;
    private EnhancedFileHandler underlyingFileHandler;

    public TimeBasedRollingFileHandler(TimeBasedRollingFileHandlerConfig config) throws IOException {
        this(config, new ISupplier<Date>(){

            @Override
            public Date get() {
                return new Date();
            }
        });
    }

    TimeBasedRollingFileHandler(TimeBasedRollingFileHandlerConfig config, ISupplier<Date> dateSupplier) throws IOException {
        this.fileNamePattern = config.getFileNamePattern();
        this.datePattern = config.getDatePattern();
        this.dateFormat = new SimpleDateFormat(this.datePattern);
        this.dateSupplier = dateSupplier;
        FileHandlerConfig underlyingFileHandlerConfig = new FileHandlerConfig(config.getLevel(), config.getFilter(), config.getFormatter(), config.getEncoding(), config.getLimit(), config.getCount(), config.isAppend(), TimeBasedRollingFileHandler.generateFileHandlerPattern(config.getFileNamePattern(), this.dateFormat, dateSupplier));
        this.underlyingFileHandler = new EnhancedFileHandler(underlyingFileHandlerConfig);
    }

    @Override
    public synchronized void publish(LogRecord rec) {
        if (!this.isLoggable(rec)) {
            return;
        }
        String fileHandlerPattern = TimeBasedRollingFileHandler.generateFileHandlerPattern(this.fileNamePattern, this.dateFormat, this.dateSupplier);
        if (!fileHandlerPattern.equals(this.underlyingFileHandler.getPattern())) {
            try {
                EnhancedFileHandler oldFileHandler = this.underlyingFileHandler;
                FileHandlerConfig newFileHandlerConfig = FileHandlerConfig.fromHandler(oldFileHandler);
                newFileHandlerConfig.setPattern(fileHandlerPattern);
                EnhancedFileHandler newFileHandler = new EnhancedFileHandler(newFileHandlerConfig);
                newFileHandler.setErrorManager(oldFileHandler.getErrorManager());
                this.underlyingFileHandler = newFileHandler;
                oldFileHandler.close();
            }
            catch (IOException e) {
                this.reportError(null, e, 4);
            }
        }
        this.underlyingFileHandler.publish(rec);
    }

    private static String generateFileHandlerPattern(String fileNamePattern, DateFormat dateFormat, ISupplier<Date> dateSupplier) {
        if (!fileNamePattern.contains("%d")) {
            throw new IllegalArgumentException("fileNamePattern must contain \"%d\"");
        }
        return fileNamePattern.replace("%d", dateFormat.format(dateSupplier.get()));
    }

    @Override
    public void flush() {
        this.underlyingFileHandler.flush();
    }

    @Override
    public void close() {
        this.underlyingFileHandler.close();
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) {
        this.underlyingFileHandler.setFormatter(newFormatter);
    }

    @Override
    public synchronized Formatter getFormatter() {
        return this.underlyingFileHandler.getFormatter();
    }

    @Override
    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.underlyingFileHandler.setEncoding(encoding);
    }

    @Override
    public synchronized String getEncoding() {
        return this.underlyingFileHandler.getEncoding();
    }

    @Override
    public synchronized void setFilter(Filter newFilter) {
        this.underlyingFileHandler.setFilter(newFilter);
    }

    @Override
    public synchronized Filter getFilter() {
        return this.underlyingFileHandler.getFilter();
    }

    @Override
    public synchronized void setErrorManager(ErrorManager em) {
        this.underlyingFileHandler.setErrorManager(em);
    }

    @Override
    public synchronized ErrorManager getErrorManager() {
        return this.underlyingFileHandler.getErrorManager();
    }

    @Override
    public synchronized void setLevel(Level newLevel) {
        this.underlyingFileHandler.setLevel(newLevel);
    }

    @Override
    public synchronized Level getLevel() {
        return this.underlyingFileHandler.getLevel();
    }

    public int getLimit() {
        return this.underlyingFileHandler.getLimit();
    }

    public int getCount() {
        return this.underlyingFileHandler.getCount();
    }

    public boolean isAppend() {
        return this.underlyingFileHandler.isAppend();
    }
}

