/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.util.sql;

import io.github.albertus82.util.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    private SqlUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, "An error occurred while closing the connection:", e);
        }
    }

    public static void closeQuietly(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, "An error occurred while closing the statement:", e);
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, "An error occurred while closing the result set:", e);
        }
    }

    public static String sanitizeName(String str) {
        return str.replaceAll("[^A-Za-z0-9_]+", "");
    }

    public static String sanitizeType(String str) {
        return str.replaceAll("[^A-Za-z0-9_,() ]+", "");
    }
}

