/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python;

import java.awt.Image;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.python.Bundle;
import org.netbeans.modules.python.PythonPropertiesNotifier;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class PythonNodes {
    private static final String IMAGE = "org/netbeans/modules/python/package.png";

    public static NodeFactory sourceNode() {
        return new PythonSourceNodeFactory();
    }

    public static NodeFactory testsNode() {
        return new PythonTestNodeFactory();
    }

    public static NodeFactory importantNode() {
        return new PythonProjectFilesNodeFactory();
    }

    public static class PythonProjectFilesNodeFactory
    implements NodeFactory {
        public NodeList createNodes(Project project) {
            try {
                ProjectFilesNode nd = new ProjectFilesNode(project);
                return NodeFactorySupport.fixedNodeList((Node[])new Node[]{nd});
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
            }
        }

        private static class ProjectFilesChildren
        extends FilterNode.Children {
            public ProjectFilesChildren(Node original) {
                super(original);
            }

            protected Node[] createNodes(Node object) {
                ArrayList<Node> result = new ArrayList<Node>();
                for (Node node : super.createNodes(object)) {
                    FileObject fileObject;
                    if (this.accept(node)) {
                        result.add(node);
                    }
                    if (!node.getDisplayName().equals("nbproject") || (fileObject = ((FileObject)node.getLookup().lookup(FileObject.class)).getFileObject("project.properties")) == null) continue;
                    Node lookup = (Node)fileObject.getLookup().lookup(Node.class);
                    result.add(lookup);
                }
                return (Node[])result.toArray(Node[]::new);
            }

            private boolean accept(Node node) {
                String displayName = node.getDisplayName();
                return StringUtils.endsWithAny((CharSequence)displayName, (CharSequence[])PythonUtility.IMPORTANT_FILES) && VisibilityQuery.getDefault().isVisible((FileObject)node.getLookup().lookup(FileObject.class));
            }
        }

        public static class ProjectFilesNode
        extends FilterNode {
            private static final String IMAGE = "org/netbeans/modules/python/config-badge.gif";

            public ProjectFilesNode(Project proj) throws DataObjectNotFoundException {
                super(DataObject.find((FileObject)proj.getProjectDirectory()).getNodeDelegate(), (Children)new ProjectFilesChildren(DataObject.find((FileObject)proj.getProjectDirectory()).getNodeDelegate()));
            }

            public String getDisplayName() {
                return Bundle.CTL_ImportantFiles();
            }

            public Image getIcon(int type) {
                Image original = super.getIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.addToolTipToImage((Image)ImageUtilities.loadImage((String)IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }

            public Image getOpenedIcon(int type) {
                Image original = super.getOpenedIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.addToolTipToImage((Image)ImageUtilities.loadImage((String)IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }
        }
    }

    public static class PythonTestNodeFactory
    implements NodeFactory {
        public NodeList createNodes(Project project) {
            try {
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("testsources");
                int n = sourceGroupArray.length;
                int n2 = 0;
                if (n2 < n) {
                    SourceGroup testSourceGroup = sourceGroupArray[n2];
                    TestFilesNode nd = new TestFilesNode(project, testSourceGroup.getRootFolder());
                    return NodeFactorySupport.fixedNodeList((Node[])new Node[]{nd});
                }
                return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new TestFilesNode(project, project.getProjectDirectory().createFolder("tests"))});
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
        }

        private static class TestsChildren
        extends FilterNode.Children
        implements ChangeListener {
            Project project;

            public TestsChildren(Node original, Project project) {
                super(original);
                this.project = project;
                PythonPropertiesNotifier.addChangeListener(this);
            }

            protected void addNotify() {
                super.addNotify();
                this.createNodes(this.original);
            }

            protected Node[] createNodes(Node object) {
                ArrayList<Node> result = new ArrayList<Node>();
                for (Node node : super.createNodes(object)) {
                    if (!this.accept(node)) continue;
                    result.add(node);
                }
                return (Node[])result.toArray(Node[]::new);
            }

            private boolean accept(Node node) {
                return !StringUtils.equalsAny((CharSequence)node.getDisplayName(), (CharSequence[])PythonUtility.EXCLUDED_DIRS) || VisibilityQuery.getDefault().isVisible((FileObject)node.getLookup().lookup(FileObject.class));
            }

            @Override
            public void stateChanged(ChangeEvent ce) {
                if (ProjectManager.getDefault().isModified(this.project)) {
                    for (SourceGroup testSourceGroup : ProjectUtils.getSources((Project)this.project).getSourceGroups("testsources")) {
                        try {
                            this.changeOriginal(DataObject.find((FileObject)testSourceGroup.getRootFolder()).getNodeDelegate());
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }

        public static class TestFilesNode
        extends FilterNode {
            public TestFilesNode(Project project, FileObject fo) throws DataObjectNotFoundException {
                super(DataObject.find((FileObject)fo).getNodeDelegate(), (Children)new TestsChildren(DataObject.find((FileObject)fo).getNodeDelegate(), project));
            }

            public String getDisplayName() {
                return Bundle.CTL_TestsName();
            }

            public Image getIcon(int type) {
                Image original = super.getIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)PythonNodes.IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }

            public Image getOpenedIcon(int type) {
                Image original = super.getOpenedIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)PythonNodes.IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }
        }
    }

    private static final class PythonSourceNodeFactory
    implements NodeFactory {
        private PythonSourceNodeFactory() {
        }

        public NodeList createNodes(Project project) {
            try {
                SourceFilesNode nd = new SourceFilesNode(project);
                return NodeFactorySupport.fixedNodeList((Node[])new Node[]{nd});
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
            }
        }

        private static class SourcesChildren
        extends FilterNode.Children
        implements ChangeListener {
            Project proj;

            public SourcesChildren(Node original, Project proj) {
                super(original);
                this.proj = proj;
                PythonPropertiesNotifier.addChangeListener(this);
            }

            protected void addNotify() {
                super.addNotify();
                this.createNodes(this.original);
            }

            protected Node[] createNodes(Node object) {
                ArrayList<Node> result = new ArrayList<Node>();
                for (Node node : super.createNodes(object)) {
                    if (!this.accept(node)) continue;
                    result.add(node);
                }
                return (Node[])result.toArray(Node[]::new);
            }

            private boolean accept(Node node) {
                String displayName = node.getDisplayName();
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.proj).getSourceGroups("testsources");
                boolean isTest = false;
                if (sourceGroups.length > 0) {
                    isTest = Paths.get(sourceGroups[0].getRootFolder().getPath(), new String[0]).endsWith(displayName);
                }
                return VisibilityQuery.getDefault().isVisible((FileObject)node.getLookup().lookup(FileObject.class)) && !StringUtils.equalsAny((CharSequence)displayName, (CharSequence[])PythonUtility.EXCLUDED_DIRS) && !displayName.equals("pyproject.toml") && !isTest && !StringUtils.endsWithAny((CharSequence)displayName, (CharSequence[])PythonUtility.IMPORTANT_FILES) && !displayName.startsWith(".");
            }

            @Override
            public void stateChanged(ChangeEvent ce) {
                if (ProjectManager.getDefault().isModified(this.proj)) {
                    this.changeOriginal(this.original);
                }
            }
        }

        public static class SourceFilesNode
        extends FilterNode {
            public SourceFilesNode(Project proj) throws DataObjectNotFoundException {
                super(DataObject.find((FileObject)proj.getProjectDirectory()).getNodeDelegate(), (Children)new SourcesChildren(DataObject.find((FileObject)proj.getProjectDirectory()).getNodeDelegate(), proj));
            }

            public String getDisplayName() {
                return Bundle.CTL_SourceName();
            }

            public Image getIcon(int type) {
                Image original = super.getIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)PythonNodes.IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }

            public Image getOpenedIcon(int type) {
                Image original = super.getOpenedIcon(type);
                original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)PythonNodes.IMAGE), (String)("<i>" + this.getDisplayName() + "</i>")), (int)7, (int)7);
                return original;
            }
        }
    }
}

