/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public final class PythonCleanVEnvAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    public static final Logger LOG = Logger.getLogger(PythonCleanVEnvAction.class.getName());
    private static final long serialVersionUID = 1L;
    private final Lookup context;
    Lookup.Result<PythonProject> lkpInfo;

    public PythonCleanVEnvAction() {
        this(Utilities.actionsGlobalContext());
    }

    public PythonCleanVEnvAction(Lookup context) {
        this.putValue("Name", Bundle.CTL_PythonCleanVEnvAction());
        this.context = context;
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(PythonProject.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        Collection allInstances = this.lkpInfo.allInstances();
        if (allInstances.isEmpty()) {
            this.setEnabled(false);
        } else if (allInstances.size() == 1 && ((PythonProject)allInstances.stream().findFirst().get()).getProjectDirectory().getFileObject(".venv") != null) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new PythonCleanVEnvAction(context);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        PythonProject get = (PythonProject)this.lkpInfo.allInstances().stream().findFirst().get();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)get.getProjectDirectory()));
        PythonUtility.manageRunEnvs(pb);
        String virtualmanager = PythonUtility.getVenv(get);
        ArrayList<String> argList = new ArrayList<String>();
        try {
            argList.addAll(Arrays.asList(PythonUtility.getPlatformPythonExe(), "-m", virtualmanager, "--clear", Paths.get(get.getProjectDirectory().getFileObject(".venv").getPath(), new String[0]).toString()));
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
            StatusDisplayer.getDefault().setStatusText(String.format("%s %s", Bundle.CTL_PythonCleanVEnvMessage(), virtualmanager));
            LifecycleManager.getDefault().saveAll();
        }, () -> {}, true, true), (String)String.format("%s %s (%s)", "Clean", virtualmanager, get.getProjectDirectory().getNameExt()));
        service.run();
    }
}

