/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public final class PythonCreateVEnvAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    public static final Logger LOG = Logger.getLogger(PythonCreateVEnvAction.class.getName());
    private static final long serialVersionUID = 1L;
    private final Lookup context;
    Lookup.Result<PythonProject> lkpInfo;

    public PythonCreateVEnvAction() {
        this(Utilities.actionsGlobalContext());
    }

    public PythonCreateVEnvAction(Lookup context) {
        this.putValue("Name", Bundle.CTL_PythonCreateVEnvAction());
        this.context = context;
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(PythonProject.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        Collection allInstances = this.lkpInfo.allInstances();
        if (allInstances.isEmpty()) {
            this.setEnabled(false);
        } else if (allInstances.size() == 1 && ((PythonProject)allInstances.stream().findFirst().get()).getProjectDirectory().getFileObject(".venv") == null) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new PythonCreateVEnvAction(context);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        PythonProject get = (PythonProject)this.lkpInfo.allInstances().stream().findFirst().get();
        try {
            PythonCreateVEnvAction.createEnv(get, PythonUtility.getPlatformPythonExe(), PythonUtility.getVenv(get));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void createEnv(PythonProject get, String python, String virtualmanager) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)get.getProjectDirectory()));
        PythonUtility.manageRunEnvs(pb);
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(python, "-m", virtualmanager, Paths.get(get.getProjectDirectory().getPath(), new String[0]).resolve(".venv").toString()));
        pb.command(argList);
        LOG.info(() -> Arrays.toString(argList.toArray()));
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
            StatusDisplayer.getDefault().setStatusText(String.format("%s %s", Bundle.CTL_PythonCreateVEnvMessage(), virtualmanager));
            LifecycleManager.getDefault().saveAll();
        }, () -> {
            if (ProjectProblems.isBroken((Project)get)) {
                ProjectProblems.showAlert((Project)get);
            }
        }, true, true), (String)String.format("%s %s (%s)", Bundle.CTL_PythonCreateVEnvMessage(), virtualmanager, get.getProjectDirectory().getNameExt()));
        service.run();
    }
}

