/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.Bundle;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class PythonDocGenerator
implements ActionListener {
    public static final Logger LOG = Logger.getLogger(PythonDocGenerator.class.getName());
    private final Project context;

    public PythonDocGenerator(Project context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)this.context.getProjectDirectory()));
        PythonUtility.manageRunEnvs(pb);
        try {
            String[] params = new String[]{};
            ArrayList<String> argList = new ArrayList<String>();
            Properties prop = PythonUtility.getProperties(this.context, false);
            params = prop.getProperty("nbproject.pdoc.params", "-o docs").split(" ");
            List<String> asList1 = null;
            asList1 = Arrays.asList(PythonUtility.getLspPythonExe(), "-m", "pdoc", Paths.get(this.context.getProjectDirectory().getPath(), new String[0]).toString());
            argList.addAll(asList1);
            argList.addAll(Arrays.asList(params));
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
            StatusDisplayer.getDefault().setStatusText(Bundle.CTL_PythonDocMessage());
            LifecycleManager.getDefault().saveAll();
        }, () -> {}, true, true), (String)String.format("%s%s%s", "Pdoc (", this.context.getProjectDirectory().getName(), ")"));
        service.run();
    }
}

