/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class PythonGenerateTest {
    public static final Logger LOG = Logger.getLogger(PythonGenerateTest.class.getName());

    public static void runAction(DataObject context) {
        FileObject primaryFile = context.getPrimaryFile();
        FileObject primaryFileParent = primaryFile.getParent();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)primaryFileParent));
        PythonUtility.manageRunEnvs(pb);
        String[] params = new String[]{};
        ArrayList<String> argList = new ArrayList<String>();
        try {
            Project owner = FileOwnerQuery.getOwner((FileObject)primaryFile);
            if (owner != null) {
                Properties prop = PythonUtility.getProperties(owner, false);
                if (!prop.getProperty("nbproject.test.generator.params", "").isEmpty()) {
                    params = prop.getProperty("nbproject.test.generator.params", "").split(" ");
                }
                SourceGroup[] testSourceGroups = ProjectUtils.getSources((Project)owner).getSourceGroups("testsources");
                String testClassName = FilenameUtils.removeExtension((String)FileUtil.getRelativePath((FileObject)owner.getProjectDirectory(), (FileObject)primaryFile)) + "Test.py";
                Path generatedTestFile = Paths.get(testSourceGroups[0].getRootFolder().getPath(), new String[0]).resolve(testClassName);
                String outputPath = prop.getProperty("nbproject.test.generator.dir", testSourceGroups.length > 0 ? generatedTestFile.getParent().toFile().toPath().toString() : Paths.get(primaryFileParent.getPath(), new String[0]).toString());
                argList.addAll(Arrays.asList(PythonUtility.getProjectPythonExe(context.getPrimaryFile()), "-m", "pynguin", "--project-path", Paths.get(primaryFileParent.getPath(), new String[0]).toString(), "--module-name", primaryFile.getName(), "--output-path", outputPath, "-v"));
                argList.addAll(Arrays.asList(params));
                pb.command(argList);
                LOG.info(() -> Arrays.toString(argList.toArray()));
                ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
                    StatusDisplayer.getDefault().setStatusText("Pynguin Generation");
                    LifecycleManager.getDefault().saveAll();
                }, () -> {
                    File generated = generatedTestFile.getParent().resolve("test_" + primaryFile.getNameExt()).toFile();
                    if (generated != null) {
                        generated.renameTo(generatedTestFile.toFile());
                        try {
                            ((EditorCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)generatedTestFile.toFile())).getLookup().lookup(EditorCookie.class)).open();
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, true, true), (String)String.format("%s%s%s", "Generating (", generatedTestFile.toFile().getName(), ")"));
                service.run();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

