/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import com.jediterm.pty.PtyProcessTtyConnector;
import com.pty4j.PtyProcess;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.repl.IPythonTopComponent;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class PythonRunSelectionAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private static final long serialVersionUID = 1L;
    private Lookup context;
    Lookup.Result<EditorCookie> lkpInfo;
    static TopComponent findTopComponent;
    static PtyProcessTtyConnector tty;
    static byte[] enterKey;

    public PythonRunSelectionAction() {
        this(Utilities.actionsGlobalContext());
    }

    public PythonRunSelectionAction(Lookup context) {
        this.putValue("Name", Bundle.CTL_RunSelectionAction());
        this.context = context;
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(EditorCookie.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        if (this.lkpInfo.allInstances().isEmpty()) {
            this.setEnabled(false);
        } else {
            try {
                JEditorPane jep = this.getJEP();
                if (jep != null && jep.getSelectedText() != null && !jep.getSelectedText().isEmpty()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public Action createContextAwareInstance(Lookup context) {
        return new PythonRunSelectionAction(context);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    private JEditorPane getJEP() throws DataObjectNotFoundException {
        EditorCookie editorCookie = this.getEC();
        JEditorPane jep = NbDocument.findRecentEditorPane((EditorCookie)editorCookie);
        if (jep == null && editorCookie.getOpenedPanes() != null) {
            jep = editorCookie.getOpenedPanes()[0];
        }
        return jep;
    }

    private EditorCookie getEC() {
        return (EditorCookie)this.lkpInfo.allInstances().stream().findFirst().get();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.init();
        EditorCookie ec = this.getEC();
        JEditorPane openedPane = ec.getOpenedPanes()[0];
        if (openedPane != null) {
            String selectedText = openedPane.getSelectedText();
            if (selectedText != null && !selectedText.isEmpty()) {
                if (findTopComponent == null) {
                    findTopComponent = WindowManager.getDefault().findTopComponent("IPythonTopComponent");
                }
                if (findTopComponent != null && !findTopComponent.isOpened()) {
                    findTopComponent.open();
                }
                findTopComponent.requestActive();
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    try {
                        IPythonTopComponent cfr_ignored_0 = (IPythonTopComponent)findTopComponent;
                        tty = (PtyProcessTtyConnector)IPythonTopComponent.ttyConnector;
                        enterKey = new byte[]{((PtyProcess)tty.getProcess()).getEnterKeyCode()};
                        tty.write(selectedText);
                        tty.write(enterKey);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.CTL_RunSelectionNoSelection());
            }
        }
    }
}

