/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.PythonRun;
import org.netbeans.modules.python.debugger.Bundle;
import org.netbeans.modules.python.debugger.PythonDebuggerName;
import org.netbeans.modules.python.debugger.PythonDebuggerProvider;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.modules.python.debugger.pdb.PdbClient;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class PythonDebugger {
    public static final String PYTHON_DEBUGGER_INFO = "PYthonDebuggerInfo";
    public static final String PYTHON_SESSION = "PYthonSession";
    public static final String PYTHON_DEBUGGER_LANGUAGE = "Python";
    private final PythonDebuggerProvider engineProvider;
    static PdbClient pdbClient;
    static ProgressHandle createHandle;
    static InputOutput io;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    public volatile Object currentLine;

    public PythonDebugger(ContextProvider contextProvider) {
        this.engineProvider = (PythonDebuggerProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
    }

    public static void startDebugger(Project owner, DataObject dob, boolean singleFile) {
        try {
            Breakpoint[] breakpoints;
            Session[] sessions;
            List<String> runArgs = PythonRun.getRunArgs(owner, dob, true);
            if (runArgs.isEmpty()) {
                return;
            }
            if (PythonUtility.getVersion(runArgs.get(0)).contains("Python 2")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Python 2 Debugging not supported at the moment", 1));
                return;
            }
            String sessionName = owner != null && !singleFile ? ProjectUtils.getInformation((Project)owner).getDisplayName() : dob.getPrimaryFile().getNameExt();
            DebuggerManager manager = DebuggerManager.getDebuggerManager();
            boolean isRunning = false;
            for (Session session : sessions = manager.getSessions()) {
                if (!session.getCurrentLanguage().equals(PYTHON_DEBUGGER_LANGUAGE)) continue;
                isRunning = true;
            }
            if (isRunning) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.CTL_MultiSession(), 1));
                return;
            }
            DebuggerInfo info = DebuggerInfo.create((String)PYTHON_DEBUGGER_INFO, (Object[])new Object[]{new PythonDebuggerName(sessionName)});
            manager.startDebugging(info);
            runArgs.addAll(1, Arrays.asList("-m", "pdb"));
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(runArgs).directory(owner != null ? FileUtil.toFile((FileObject)owner.getProjectDirectory()) : FileUtil.toFile((FileObject)dob.getPrimaryFile().getParent()));
            PythonUtility.manageRunEnvs(pb);
            Process process = pb.redirectErrorStream(true).start();
            createHandle = ProgressHandle.createHandle((String)String.format("%s (%s)", Bundle.CTL_SessionName(), sessionName));
            createHandle.start();
            createHandle.suspend("Running");
            io = IOProvider.getDefault().getIO(String.format("%s (%s)", Bundle.CTL_SessionName(), sessionName), false);
            io.select();
            pdbClient = new PdbClient(process, io);
            IOColorLines.println((InputOutput)io, (CharSequence)"[LOG]PythonDebugger: Starting new Debugging Session using PDB...", (Color)Color.BLUE);
            IOColorLines.println((InputOutput)io, (CharSequence)"[LOG]This is a Lite wrapper around the built in Python debugger", (Color)Color.BLUE);
            IOColorLines.println((InputOutput)io, (CharSequence)"[LOG]Please do not file bugs about this debugger, which is scheduled to be replaced.", (Color)Color.BLUE);
            pdbClient.processResponse(pdbClient.getStreamResponse(true));
            for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
                boolean managePdbBreakPoints;
                if (!(breakpoint instanceof PythonBreakpoint) || (managePdbBreakPoints = PythonDebuggerUtils.managePdbBreakPoints((PythonBreakpoint)breakpoint, "add"))) continue;
                ((PythonBreakpoint)breakpoint).setBreakPointValidity(Breakpoint.VALIDITY.INVALID, "Invalid");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void kill() {
        try {
            pdbClient.sendCommand("quit");
            pdbClient.getProcess().destroyForcibly();
            pdbClient.getReader().close();
            pdbClient.getWriter().close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.engineProvider.getDestructor().killEngine();
        io.closeInputOutput();
        createHandle.finish();
    }

    public PdbClient getPdbClient() {
        return pdbClient;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    public boolean isFinished() {
        return pdbClient.isFinished();
    }

    public boolean isSuspended() {
        return pdbClient.isSuspended();
    }

    public List getCallStacks() {
        try {
            return pdbClient.sendWhere("where");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    public void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    public void fireSessionState() {
        for (StateListener sl : this.stateListeners) {
            sl.suspended(true);
        }
    }

    public void fireCurrentThread() {
        for (StateListener sl : this.stateListeners) {
            sl.currentThread();
        }
    }

    public static interface StateListener
    extends EventListener {
        public void currentThread();

        public void currentFrame();

        public void suspended(boolean var1);

        public void finished();
    }
}

