/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.pdb.PdbClient;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PythonDebuggerActionsProvider
extends ActionsProviderSupport {
    private static final Set<Object> ACTIONS = new HashSet<Object>();
    private static final Set<Object> ACTIONS_TO_DISABLE = new HashSet<Object>();
    private final PythonDebugger debugger;
    private static RequestProcessor actionsRequestProcessor;
    private static RequestProcessor killRequestProcessor;
    static PdbClient pdbClient;

    public PythonDebuggerActionsProvider(ContextProvider contextProvider) {
        this.debugger = (PythonDebugger)contextProvider.lookupFirst(null, PythonDebugger.class);
        Iterator<Object> it = ACTIONS.iterator();
        while (it.hasNext()) {
            this.setEnabled(it.next(), true);
        }
    }

    public void doAction(Object action) {
        pdbClient = this.debugger.getPdbClient();
        PythonDebuggerUtils.unmarkCurrent();
        PythonDebuggerUtils.unmarkStacks();
        try {
            if (action.equals(ActionsManager.ACTION_KILL)) {
                this.debugger.kill();
            } else if (action.equals(ActionsManager.ACTION_RESTART)) {
                pdbClient.sendCommandAndProcessResponse("restart");
            } else if (action.equals(ActionsManager.ACTION_CONTINUE)) {
                pdbClient.sendCommandAndProcessResponse("continue");
            } else if (action.equals(ActionsManager.ACTION_STEP_OVER)) {
                pdbClient.sendCommandAndProcessResponse("next");
            } else if (action.equals(ActionsManager.ACTION_STEP_INTO)) {
                pdbClient.sendCommandAndProcessResponse("step");
            } else if (action.equals(ActionsManager.ACTION_STEP_OUT)) {
                pdbClient.sendCommandAndProcessResponse("return");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(Object action, Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_KILL) {
            Class<PythonDebugger> clazz = PythonDebugger.class;
            synchronized (PythonDebugger.class) {
                if (killRequestProcessor == null) {
                    killRequestProcessor = new RequestProcessor("PYthon debugger finish RP", 1);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                killRequestProcessor.post(() -> {
                    try {
                        this.doAction(action);
                    }
                    finally {
                        actionPerformedNotifier.run();
                    }
                });
                return;
            }
        }
        this.setDebugActionsEnabled(false);
        Class<PythonDebugger> clazz = PythonDebugger.class;
        synchronized (PythonDebugger.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("PYthon debugger actions RP", 1);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            actionsRequestProcessor.post(() -> {
                try {
                    this.doAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                    this.setDebugActionsEnabled(true);
                }
            });
            return;
        }
    }

    private void setDebugActionsEnabled(boolean enabled) {
        for (Object action : ACTIONS_TO_DISABLE) {
            this.setEnabled(action, enabled);
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    static {
        ACTIONS.add(ActionsManager.ACTION_KILL);
        ACTIONS.add(ActionsManager.ACTION_RESTART);
        ACTIONS.add(ActionsManager.ACTION_CONTINUE);
        ACTIONS.add(ActionsManager.ACTION_STEP_OVER);
        ACTIONS.add(ActionsManager.ACTION_STEP_INTO);
        ACTIONS.add(ActionsManager.ACTION_STEP_OUT);
        ACTIONS_TO_DISABLE.addAll(ACTIONS);
        ACTIONS_TO_DISABLE.remove(ActionsManager.ACTION_KILL);
    }
}

