/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class PythonDebuggerToolTip
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        PythonDebugger d = (PythonDebugger)currentEngine.lookupFirst(null, PythonDebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part partLine = (Line.Part)this.getAttachedAnnotatable();
        if (partLine == null) {
            return null;
        }
        Line line = partLine.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie editCookie = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
        if (editCookie == null) {
            return null;
        }
        this.lp = partLine;
        this.ec = editCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        StyledDocument doc;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return;
        }
        String expression = PythonDebuggerToolTip.getIdentifier(doc, ep, NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (expression == null) {
            return;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return;
        }
        PythonDebugger d = (PythonDebugger)currentEngine.lookupFirst(null, PythonDebugger.class);
        if (d == null) {
            return;
        }
        try {
            String command = String.format("%s %s ;; %s", "whatis", expression, expression);
            String value = d.getPdbClient().sendCommandAndGetResponse(command);
            if (!value.isEmpty()) {
                String toolTipText = expression + " = " + value;
                this.firePropertyChange("shortDescription", null, toolTipText);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            lineLen = t.length();
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String ident = t.substring(identStart, identEnd);
            while (identEnd < lineLen && Character.isWhitespace(t.charAt(identEnd))) {
                ++identEnd;
            }
            return ident;
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

