/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.python.debugger.DebuggerAnnotation;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.PythonDebuggerCallStack;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.modules.python.debugger.pdb.PdbClient;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class PythonDebuggerUtils {
    private static Object currentLine;
    private static ArrayList<DebuggerAnnotation> markedStacks;

    public static synchronized void markCurrent(Object line) {
        PythonDebuggerUtils.unmarkCurrent();
        Annotatable[] annotatables = (Annotatable[])line;
        int i = 0;
        int k = annotatables.length;
        DebuggerAnnotation[] annotations = new DebuggerAnnotation[k];
        annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPCLinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC", annotatables[i]);
        for (i = 1; i < k; ++i) {
            annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPC2LinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC2", annotatables[i]);
        }
        currentLine = annotations;
        PythonDebugger debugger = PythonDebuggerUtils.getDebugger();
        debugger.currentLine = line;
        PythonDebuggerUtils.showLine(line);
    }

    public static synchronized void unmarkCurrent() {
        if (currentLine != null) {
            int k = ((DebuggerAnnotation[])currentLine).length;
            for (int i = 0; i < k; ++i) {
                ((DebuggerAnnotation[])currentLine)[i].detach();
            }
            currentLine = null;
        }
    }

    public static synchronized void markStacks(List callStacks) {
        PythonDebuggerUtils.unmarkStacks();
        if (callStacks.isEmpty()) {
            return;
        }
        callStacks.remove(0);
        ArrayList<DebuggerAnnotation> stackAnnotations = new ArrayList<DebuggerAnnotation>();
        for (Object callStack : callStacks) {
            PythonDebuggerCallStack stack = (PythonDebuggerCallStack)callStack;
            Line location = stack.location();
            if (location == null) {
                return;
            }
            Annotatable[] annotatables = new Annotatable[]{location};
            stackAnnotations.add(new DebuggerAnnotation("CallSite", annotatables[0]));
        }
        markedStacks = stackAnnotations;
    }

    public static synchronized void unmarkStacks() {
        if (markedStacks != null) {
            for (DebuggerAnnotation markedStack : markedStacks) {
                markedStack.detach();
            }
            markedStacks = null;
        }
    }

    public static void showLine(Object line) {
        Annotatable[] a = (Annotatable[])line;
        SwingUtilities.invokeLater(() -> {
            if (a[0] instanceof Line) {
                ((Line)a[0]).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            } else if (a[0] instanceof Line.Part) {
                ((Line.Part)a[0]).getLine().show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            } else {
                throw new InternalError(a[0].toString());
            }
        });
    }

    public static boolean contains(Object currentLine, Line line) {
        if (currentLine == null) {
            return false;
        }
        Annotatable[] a = (Annotatable[])currentLine;
        int k = a.length;
        for (int i = 0; i < k; ++i) {
            if (a[i].equals(line)) {
                return true;
            }
            if (!(a[i] instanceof Line.Part) || !((Line.Part)a[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean managePdbBreakPoints(PythonBreakpoint pb, String action) {
        try {
            Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (currentSession == null) {
                return true;
            }
            if (!currentSession.getCurrentLanguage().equals("Python")) {
                return true;
            }
            if (pb.getValidity().equals((Object)Breakpoint.VALIDITY.INVALID)) {
                return true;
            }
            DebuggerEngine currentEngine = currentSession.getCurrentEngine();
            PythonDebugger debugger = (PythonDebugger)currentEngine.lookupFirst(null, PythonDebugger.class);
            PdbClient pdbClient = debugger.getPdbClient();
            String condition = pb.getCondition();
            switch (action) {
                case "enable": {
                    Object[] responseE = pdbClient.sendBreakpointsCommand(String.format("%s %s", "enable", pb.getID()));
                    boolean validE = (Boolean)responseE[0];
                    if (validE) {
                        pb.setID((Integer)responseE[1]);
                    }
                    return validE;
                }
                case "disable": {
                    Object[] responseD = pdbClient.sendBreakpointsCommand(String.format("%s %s", "disable", pb.getID()));
                    boolean validD = (Boolean)responseD[0];
                    if (validD) {
                        pb.setID((Integer)responseD[1]);
                    }
                    return validD;
                }
                case "add": {
                    Object[] responseA;
                    boolean validA;
                    String command = String.format("%s %s:%s", "break", pb.getFileObject().getPath(), pb.getLineNumber());
                    if (condition != null && !condition.trim().isEmpty()) {
                        command = String.format("%s , %s", command, condition);
                    }
                    if (validA = ((Boolean)(responseA = pdbClient.sendBreakpointsCommand(command))[0]).booleanValue()) {
                        pb.setID((Integer)responseA[1]);
                    }
                    return validA;
                }
                case "remove": {
                    Object[] responseR = pdbClient.sendBreakpointsCommand(String.format("%s %s:%s", "clear", pb.getFileObject().getPath(), pb.getLineNumber()));
                    if (Utilities.isWindows()) {
                        return true;
                    }
                    boolean validR = (Boolean)responseR[0];
                    if (validR) {
                        pb.setID((Integer)responseR[1]);
                    }
                    return validR;
                }
            }
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static PythonDebugger getDebugger() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return null;
        }
        return (PythonDebugger)engine.lookupFirst(null, PythonDebugger.class);
    }

    public static boolean isCurrent() {
        return currentLine != null;
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color == null && (color = UIManager.getColor("Table.foreground")) == null) {
            color = new JTable().getForeground();
        }
        sb.append("<font color=\"#");
        String hexColor = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        for (int i = hexColor.length(); i < 6; ++i) {
            sb.append("0");
        }
        sb.append(hexColor);
        sb.append("\">");
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        sb.append(text);
        sb.append("</font>");
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

