/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.python.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
extends DebuggerManagerAdapter
implements AnnotationProvider {
    private final Map<PythonBreakpoint, Set<Annotation>> breakpointToAnnotations = new IdentityHashMap<PythonBreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private volatile boolean breakpointsActive = true;
    private final RequestProcessor annotationProcessor = new RequestProcessor("Python BP Annotation Refresh", 1);

    public BreakpointAnnotationProvider() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo != null) {
            DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
            if (dobj != null) {
                PropertyChangeListener pchl = evt -> {
                    if ("primaryFile".equals(evt.getPropertyName())) {
                        DataObject dobj1 = (DataObject)evt.getSource();
                        FileObject newFO = dobj1.getPrimaryFile();
                        this.annotationProcessor.post(() -> this.annotate(newFO));
                    }
                };
                dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(pchl);
                }
            }
            this.annotate(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(FileObject fo) {
        Map<PythonBreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                PythonBreakpoint b;
                if (!(breakpoint instanceof PythonBreakpoint) || (b = (PythonBreakpoint)breakpoint).isHidden() || !BreakpointAnnotationProvider.isAt(b, fo)) continue;
                if (!this.breakpointToAnnotations.containsKey((Object)b)) {
                    b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                }
                this.removeAnnotations(b);
                this.addAnnotationTo(b);
            }
            this.annotatedFiles.add(fo);
        }
    }

    private static boolean isAt(PythonBreakpoint b, FileObject fo) {
        FileObject bfo = b.getFileObject();
        return fo.equals(bfo);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof PythonBreakpoint && !((PythonBreakpoint)breakpoint).isHidden()) {
            this.postAnnotationRefresh((PythonBreakpoint)breakpoint, false, true);
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof PythonBreakpoint && !((PythonBreakpoint)breakpoint).isHidden()) {
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.postAnnotationRefresh((PythonBreakpoint)breakpoint, true, false);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof PythonBreakpoint) {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "enabled": 
                case "validity": 
                case "condition": {
                    this.postAnnotationRefresh((PythonBreakpoint)((Object)source), true, true);
                }
            }
        }
    }

    void setBreakpointsActive(boolean active) {
        if (this.breakpointsActive == active) {
            return;
        }
        this.breakpointsActive = active;
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(null, true, true));
    }

    private void postAnnotationRefresh(PythonBreakpoint b, boolean remove, boolean add) {
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, remove, add));
    }

    private static String getAnnotationType(PythonBreakpoint b, boolean isConditional, boolean active) {
        Object annotationType;
        boolean isInvalid;
        boolean bl = isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        Object object = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (annotationType = isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        if (!active) {
            annotationType = (String)annotationType + "_stroke";
        } else if (isInvalid && b.isEnabled()) {
            annotationType = (String)annotationType + "_broken";
        }
        return annotationType;
    }

    private void addAnnotationTo(PythonBreakpoint b) {
        assert (Thread.holdsLock(this.breakpointToAnnotations));
        String condition = BreakpointAnnotationProvider.getCondition(b);
        boolean isConditional = condition != null && condition.trim().length() > 0 || b.getHitCountFilteringStyle() != null;
        String annotationType = BreakpointAnnotationProvider.getAnnotationType(b, isConditional, this.breakpointsActive);
        DebuggerBreakpointAnnotation annotation = DebuggerBreakpointAnnotation.create(annotationType, b);
        if (annotation == null) {
            return;
        }
        Set<Annotation> bpAnnotations = this.breakpointToAnnotations.get((Object)b);
        if (bpAnnotations == null) {
            WeakSet set = new WeakSet();
            set.add(annotation);
            this.breakpointToAnnotations.put(b, (Set<Annotation>)set);
        } else {
            bpAnnotations.add((Annotation)annotation);
            this.breakpointToAnnotations.put(b, bpAnnotations);
        }
    }

    private void removeAnnotations(PythonBreakpoint b) {
        assert (Thread.holdsLock(this.breakpointToAnnotations));
        Set<Annotation> annotations = this.breakpointToAnnotations.remove((Object)b);
        if (annotations == null) {
            return;
        }
        for (Annotation a : annotations) {
            a.detach();
        }
    }

    static String getCondition(Breakpoint b) {
        if (b instanceof PythonBreakpoint) {
            return ((PythonBreakpoint)b).getCondition();
        }
        throw new IllegalStateException(b.toString());
    }

    private final class AnnotationRefresh
    implements Runnable {
        private final PythonBreakpoint b;
        private final boolean remove;
        private final boolean add;

        public AnnotationRefresh(PythonBreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<PythonBreakpoint, Set<Annotation>> map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.b != null) {
                    this.refreshAnnotation(this.b);
                } else {
                    ArrayList<PythonBreakpoint> bpts = new ArrayList<PythonBreakpoint>(BreakpointAnnotationProvider.this.breakpointToAnnotations.keySet());
                    for (PythonBreakpoint bp : bpts) {
                        this.refreshAnnotation(bp);
                    }
                }
            }
        }

        private void refreshAnnotation(PythonBreakpoint b) {
            assert (Thread.holdsLock(BreakpointAnnotationProvider.this.breakpointToAnnotations));
            BreakpointAnnotationProvider.this.removeAnnotations(b);
            if (this.remove && !this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.remove((Object)b);
            }
            if (this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet());
                for (FileObject fo : BreakpointAnnotationProvider.this.annotatedFiles) {
                    if (!BreakpointAnnotationProvider.isAt(b, fo)) continue;
                    BreakpointAnnotationProvider.this.addAnnotationTo(b);
                }
            }
        }
    }
}

