/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.breakpoints;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import javax.swing.Action;
import org.netbeans.modules.python.debugger.breakpoints.Bundle;
import org.netbeans.modules.python.debugger.breakpoints.ControllerProvider;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpointCustomizer;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpointCustomizerPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.Line;
import org.openide.util.HelpCtx;

public class BreakpointNodeActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)Bundle.LBL_Action_Go_To_Source(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointNodeActionsProvider.goToSource((PythonBreakpoint)((Object)nodes[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)Bundle.LBL_Action_Customize(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointNodeActionsProvider.customize((PythonBreakpoint)((Object)nodes[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (!(node instanceof PythonBreakpoint)) {
            return original.getActions(node);
        }
        Action[] oas = original.getActions(node);
        Action[] as = new Action[oas.length + 3];
        as[0] = GO_TO_SOURCE_ACTION;
        as[1] = null;
        System.arraycopy(oas, 0, as, 2, oas.length);
        as[as.length - 1] = CUSTOMIZE_ACTION;
        return as;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof PythonBreakpoint) {
            BreakpointNodeActionsProvider.goToSource((PythonBreakpoint)((Object)node));
        } else {
            original.performDefaultAction(node);
        }
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void goToSource(PythonBreakpoint b) {
        b.getLine().show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
    }

    private static void customize(PythonBreakpoint lb) {
        PythonBreakpointCustomizerPanel c = PythonBreakpointCustomizer.getCustomizerComponent(lb);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)c);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        Controller cc = c instanceof ControllerProvider ? ((ControllerProvider)c).getController() : (Controller)c;
        Controller[] cPtr = new Controller[]{cc};
        DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
        Dialog[] dialogPtr = new Dialog[1];
        ActionListener buttonsActionListener = ev -> {
            if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                boolean ok = cPtr[0].ok();
                if (ok) {
                    dialogPtr[0].setVisible(false);
                }
            } else {
                dialogPtr[0].setVisible(false);
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)c, Bundle.CTL_Breakpoint_Customizer_Title(), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
        descriptor.setClosingOptions(new Object[0]);
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.pack();
        descriptorPtr[0] = descriptor;
        dialogPtr[0] = d;
        d.setVisible(true);
    }
}

