/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class PythonBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final String[] PYTHON_MIME_TYPES = new String[]{"text/x-python"};
    private static final Set<String> PYTHON_MIME_TYPES_SET = new HashSet<String>(Arrays.asList(PYTHON_MIME_TYPES));
    private static final Set ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    EditorContextDispatcher context = EditorContextDispatcher.getDefault();

    public PythonBreakpointActionProvider() {
        for (String mimeType : PYTHON_MIME_TYPES) {
            this.context.addPropertyChangeListener(mimeType, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public void doAction(Object action) {
        PythonBreakpoint create;
        boolean managePdbBreakPoints;
        int i;
        Line line = PythonBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return;
        }
        int lineNumber = line.getLineNumber() + 1;
        int k = breakpoints.length;
        for (i = 0; i < k; ++i) {
            PythonBreakpoint pb;
            if (!(breakpoints[i] instanceof PythonBreakpoint) || !fo.equals((pb = (PythonBreakpoint)breakpoints[i]).getFileObject()) || pb.getLineNumber() != lineNumber) continue;
            managePdbBreakPoints = PythonDebuggerUtils.managePdbBreakPoints(pb, "remove");
            if (!managePdbBreakPoints) break;
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)pb);
            break;
        }
        if (i == k && (managePdbBreakPoints = PythonDebuggerUtils.managePdbBreakPoints(create = PythonBreakpoint.create(line), "add"))) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)create);
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    private static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!PythonBreakpointActionProvider.isPythonFile(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isPythonFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return PYTHON_MIME_TYPES_SET.contains(fo.getMIMEType());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = PythonBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

