/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.breakpoints;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.breakpoints.ControllerProvider;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.Mnemonics;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class PythonBreakpointCustomizerPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(PythonBreakpointCustomizerPanel.class.getName());
    private static final int MAX_SAVED_CONDITIONS = 10;
    private static final RequestProcessor RP = new RequestProcessor(PythonBreakpointCustomizerPanel.class);
    private static final String[] PYTHON_MIME_TYPES = new String[]{"text/x-python"};
    private static final Set<String> PYTHON_MIME_TYPES_SET = new HashSet<String>(Arrays.asList(PYTHON_MIME_TYPES));
    private final Controller controller;
    private final PythonBreakpoint lb;
    private boolean createBreakpoint;
    private JCheckBox conditionCheckBox;
    private JComboBox conditionComboBox;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JSeparator jSeparator1;
    private JLabel lineLabel;
    private JTextField lineTextField;

    private static PythonBreakpoint createBreakpoint() {
        Line line = PythonBreakpointCustomizerPanel.getCurrentLine();
        if (line == null) {
            return null;
        }
        return PythonBreakpoint.create(line);
    }

    private static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!PythonBreakpointCustomizerPanel.isPythonFile(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isPythonFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return PYTHON_MIME_TYPES_SET.contains(fo.getMIMEType());
    }

    public PythonBreakpointCustomizerPanel() {
        this(PythonBreakpointCustomizerPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public PythonBreakpointCustomizerPanel(PythonBreakpoint lb) {
        this.lb = lb;
        this.initComponents();
        this.controller = this.createController();
        if (lb != null) {
            Line line = lb.getLine();
            FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
            if (fo != null) {
                File file = FileUtil.toFile((FileObject)fo);
                if (file != null) {
                    this.fileTextField.setText(file.getAbsolutePath());
                } else {
                    this.fileTextField.setText(fo.toURL().toExternalForm());
                }
            }
            this.lineTextField.setText(Integer.toString(line.getLineNumber() + 1));
            Object[] conditions = PythonBreakpointCustomizerPanel.getSavedConditions();
            this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(conditions));
            String condition = lb.getCondition();
            if (condition != null && !condition.isEmpty()) {
                this.conditionCheckBox.setSelected(true);
                this.conditionComboBox.setEnabled(true);
                this.conditionComboBox.getEditor().setItem(condition);
            } else {
                this.conditionCheckBox.setSelected(false);
                this.conditionComboBox.setEnabled(false);
            }
        }
    }

    private static Object[] getSavedConditions() {
        return Properties.getDefault().getProperties("debugger.python").getArray("BPConditions", new Object[0]);
    }

    private static void saveCondition(String condition) {
        Object[] savedConditions = PythonBreakpointCustomizerPanel.getSavedConditions();
        Object[] conditions = null;
        boolean containsCondition = false;
        for (int i = 0; i < savedConditions.length; ++i) {
            Object c = savedConditions[i];
            if (!condition.equals(c)) continue;
            containsCondition = true;
            conditions = savedConditions;
            if (i <= 0) break;
            System.arraycopy(conditions, 0, conditions, 1, i);
            conditions[0] = condition;
            break;
        }
        if (!containsCondition) {
            if (savedConditions.length < 10) {
                conditions = new Object[savedConditions.length + 1];
                conditions[0] = condition;
                System.arraycopy(savedConditions, 0, conditions, 1, savedConditions.length);
            } else {
                conditions = savedConditions;
                System.arraycopy(conditions, 0, conditions, 1, conditions.length - 1);
                conditions[0] = condition;
            }
        }
        Properties.getDefault().getProperties("debugger.python").setArray("BPConditions", conditions);
    }

    protected Controller createController() {
        return new CustomizerController();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    protected RequestProcessor getUpdateRP() {
        return RP;
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.lineLabel = new JLabel();
        this.lineTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.conditionCheckBox = new JCheckBox();
        this.conditionComboBox = new JComboBox();
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.fileLabel.text"));
        this.fileTextField.setToolTipText(NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.fileTextField.toolTipText"));
        this.lineLabel.setLabelFor(this.lineTextField);
        Mnemonics.setLocalizedText((JLabel)this.lineLabel, (String)NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.lineLabel.text"));
        this.lineTextField.setToolTipText(NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.lineTextField.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.conditionCheckBox.text"));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonBreakpointCustomizerPanel.this.conditionCheckBoxActionPerformed(evt);
            }
        });
        this.conditionComboBox.setEditable(true);
        this.conditionComboBox.setToolTipText(NbBundle.getMessage(PythonBreakpointCustomizerPanel.class, (String)"PythonBreakpointCustomizerPanel.conditionComboBox.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.conditionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conditionComboBox, 0, 330, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineLabel).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.lineTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineLabel).addComponent(this.lineTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.conditionCheckBox).addComponent(this.conditionComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void conditionCheckBoxActionPerformed(ActionEvent evt) {
        this.conditionComboBox.setEnabled(this.conditionCheckBox.isSelected());
        if (this.conditionCheckBox.isSelected()) {
            this.conditionComboBox.requestFocusInWindow();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLineBreakpointJavaScript");
    }

    private static String toURL(String filePath) {
        URI uri = null;
        try {
            uri = URI.create(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null || !uri.isAbsolute()) {
            File f = new File(filePath);
            uri = Utilities.toURI((File)f);
        }
        try {
            return uri.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return filePath;
        }
    }

    public static Line getLine(String filePath, int lineNumber) {
        if (filePath == null || lineNumber < 0) {
            return null;
        }
        FileObject fileObject = null;
        URI uri = URI.create(filePath);
        if (uri.isAbsolute()) {
            URL url;
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException muex) {
                LOG.log(Level.INFO, "Cannot resolve " + filePath, muex);
                return null;
            }
            fileObject = URLMapper.findFileObject((URL)url);
        }
        if (fileObject == null) {
            File file = filePath.startsWith("file:/") ? Utilities.toFile((URI)uri) : new File(filePath);
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileObject == null) {
            LOG.log(Level.INFO, "Cannot resolve \"{0}\"", filePath);
            return null;
        }
        LineCookie lineCookie = PythonBreakpointCustomizerPanel.getLineCookie(fileObject);
        if (lineCookie == null) {
            LOG.log(Level.INFO, "No line cookie for \"{0}\"", fileObject);
            return null;
        }
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (!lines.isEmpty()) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    public static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private class CustomizerController
    implements Controller {
        private CustomizerController() {
        }

        public boolean ok() {
            boolean managePdbBreakPoints;
            int lineNumber;
            PythonBreakpoint lb = PythonBreakpointCustomizerPanel.this.lb;
            String fileStr = PythonBreakpointCustomizerPanel.toURL(PythonBreakpointCustomizerPanel.this.fileTextField.getText());
            try {
                lineNumber = Integer.parseInt(PythonBreakpointCustomizerPanel.this.lineTextField.getText());
            }
            catch (NumberFormatException nfex) {
                return false;
            }
            Line line = PythonBreakpointCustomizerPanel.getLine(fileStr, --lineNumber);
            if (line == null) {
                return false;
            }
            if (lb != null) {
                this.updateBreakpoint(lb, line);
            } else {
                lb = PythonBreakpoint.create(line);
            }
            this.setCondition(lb);
            if (PythonBreakpointCustomizerPanel.this.createBreakpoint && (managePdbBreakPoints = PythonDebuggerUtils.managePdbBreakPoints(lb, "add"))) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            }
            return true;
        }

        private void setCondition(PythonBreakpoint lb1) {
            String condition = null;
            if (PythonBreakpointCustomizerPanel.this.conditionCheckBox.isSelected()) {
                condition = PythonBreakpointCustomizerPanel.this.conditionComboBox.getSelectedItem().toString().trim();
            }
            if (condition != null && !condition.isEmpty()) {
                lb1.setCondition(condition);
                PythonBreakpointCustomizerPanel.saveCondition(condition);
            } else {
                lb1.setCondition(null);
            }
        }

        private void updateBreakpoint(PythonBreakpoint lb, Line line) {
            PythonBreakpointCustomizerPanel.this.getUpdateRP().post(() -> {
                boolean managePdbBreak = PythonDebuggerUtils.managePdbBreakPoints(lb, "remove");
                if (managePdbBreak) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lb);
                }
                PythonBreakpoint create = PythonBreakpoint.create(line);
                this.setCondition(create);
                boolean managePdbBreakPoints = PythonDebuggerUtils.managePdbBreakPoints(create, "add");
                if (managePdbBreakPoints) {
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)create);
                }
            });
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

