/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class PythonReformatTask
implements ReformatTask {
    private final Context context;
    private static final Comparator<TextEdit> rangeReverseSort = (s1, s2) -> {
        int l1 = s1.getRange().getEnd().getLine();
        int l2 = s2.getRange().getEnd().getLine();
        int c1 = s1.getRange().getEnd().getCharacter();
        int c2 = s2.getRange().getEnd().getCharacter();
        if (l1 != l2) {
            return l2 - l1;
        }
        return c2 - c1;
    };

    public PythonReformatTask(Context context) {
        this.context = context;
    }

    public void reformat() throws BadLocationException {
        LSPBindings bindings;
        Document document = this.context.document();
        boolean rangeOrDoc = this.context.startOffset() != 0;
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null && (bindings = LSPBindings.getBindings((FileObject)fileObject)) != null) {
            boolean documentFormatting = Utils.isEnabled((Either)bindings.getInitResult().getCapabilities().getDocumentFormattingProvider());
            boolean rangeFormatting = Utils.isEnabled((Either)bindings.getInitResult().getCapabilities().getDocumentRangeFormattingProvider());
            if (rangeFormatting && rangeOrDoc) {
                this.rangeFormat(NbEditorUtilities.getFileObject((Document)document), bindings);
            } else if (documentFormatting && !rangeOrDoc) {
                this.documentFormat(NbEditorUtilities.getFileObject((Document)document), bindings);
            }
        }
    }

    private void rangeFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentRangeFormattingParams drfp = new DocumentRangeFormattingParams();
        drfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI((FileObject)fo)));
        drfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.context.document()), IndentUtils.isExpandTabs((Document)this.context.document())));
        drfp.setRange(new Range(Utils.createPosition((Document)this.context.document(), (int)this.context.startOffset()), Utils.createPosition((Document)this.context.document(), (int)this.context.endOffset())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits = new ArrayList((Collection)bindings.getTextDocumentService().rangeFormatting(drfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, String.format("LSP document rangeFormat failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void documentFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentFormattingParams dfp = new DocumentFormattingParams();
        dfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI((FileObject)fo)));
        dfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.context.document()), IndentUtils.isExpandTabs((Document)this.context.document())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits.addAll((Collection)bindings.getTextDocumentService().formatting(dfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, String.format("LSP document format failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void applyTextEdits(List<TextEdit> edits) {
        if (this.context.document() instanceof StyledDocument) {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)this.context.document()), () -> PythonReformatTask.applyEditsNoLock(this.context.document(), edits, this.context.startOffset(), this.context.endOffset()));
        } else {
            PythonReformatTask.applyEditsNoLock(this.context.document(), edits, this.context.startOffset(), this.context.endOffset());
        }
    }

    public static void applyEditsNoLock(Document doc, List<? extends TextEdit> edits, Integer startLimit, Integer endLimit) {
        edits.stream().sorted(rangeReverseSort).forEach(te -> {
            try {
                int start = Utils.getOffset((Document)doc, (Position)te.getRange().getStart());
                int end = Utils.getOffset((Document)doc, (Position)te.getRange().getEnd());
                if (!(startLimit != null && start < startLimit || endLimit != null && end < 0 && endLimit < 0)) {
                    doc.remove(start, end - start < 0 || end - start > endLimit ? endLimit - start : end - start);
                    doc.insertString(start, te.getNewText(), null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    public ExtraLock reformatLock() {
        return null;
    }
}

