/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.indexing.PythonDefaultError;
import org.netbeans.modules.python.indexing.PythonErrorConvertor;
import org.netbeans.modules.python.tasklist.PythonDiagCollector;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PythonCustomIndexer
extends CustomIndexer {
    public static final Logger LOG = Logger.getLogger(PythonCustomIndexer.class.getName());
    static Pattern PYTHON_CLASS = Pattern.compile(".*\\nclass\\s+([^\\(|:]+).*:");
    static Pattern PYTHON_METHOD = Pattern.compile(".*def\\s+([^\\(|:]+).*:");
    public static final String TYPE_FIELD = "classes";
    public static final String SYMBOLS_FIELD = "methods";

    protected void index(Iterable<? extends Indexable> files, Context context) {
        boolean pyLibPath;
        long startTime = System.currentTimeMillis();
        int cnt = 0;
        if (context.isCancelled()) {
            LOG.fine("Indexer cancelled");
            return;
        }
        FileObject root = context.getRoot();
        Project owner = root != null ? FileOwnerQuery.getOwner((FileObject)root) : null;
        boolean pyProject = owner != null && owner.getClass().getName().equals("org.netbeans.modules.python.project.PythonProject");
        boolean bl = pyLibPath = root != null && root.getParent() != null && root.getParent().getName().equals("lib");
        if (pyProject || pyLibPath) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : files) {
                    String content;
                    boolean notSkipped;
                    File toFile = Paths.get(indexable.getURL().toURI()).toFile();
                    FileObject fo = FileUtil.toFileObject((File)toFile);
                    if (!fo.getExt().equals("py")) continue;
                    boolean bl2 = notSkipped = !StringUtils.containsAny((CharSequence)toFile.toPath().toString(), (CharSequence[])PythonUtility.EXCLUDED_DIRS);
                    if (pyProject && notSkipped) {
                        content = this.getContent(fo);
                        this.setErrors(fo, context, indexable);
                        this.setClasses(content, is, indexable);
                        this.setMethods(content, is, indexable);
                        ++cnt;
                    }
                    if (!pyLibPath || !notSkipped) continue;
                    content = this.getContent(fo);
                    this.setClasses(content, is, indexable);
                    ++cnt;
                }
            }
            catch (IOException | URISyntaxException | BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        long endTime = System.currentTimeMillis();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Processed {0} files in {1}ms.", new Object[]{cnt, endTime - startTime});
        }
    }

    private String getContent(FileObject fo) throws BadLocationException, IOException {
        EditorCookie lookup = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
        StyledDocument openDocument = lookup.openDocument();
        return openDocument.getText(0, openDocument.getEndPosition().getOffset());
    }

    private void setClasses(String content, IndexingSupport is, Indexable file) throws IOException, BadLocationException {
        IndexDocument createDocument = is.createDocument(file);
        PYTHON_CLASS.matcher(content).results().forEach(match -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(match.group(1));
            stringBuilder.append("#");
            stringBuilder.append(match.start(1));
            createDocument.addPair(TYPE_FIELD, stringBuilder.toString(), true, true);
        });
        is.addDocument(createDocument);
    }

    private void setErrors(FileObject fo, Context context, Indexable file) {
        ArrayList<PythonDefaultError> errors = new ArrayList<PythonDefaultError>();
        boolean hasErrors = PythonDiagCollector.hasErrors(fo);
        PythonDefaultError pythonDefaultError = new PythonDefaultError("PARSING", "badging_error", "badging_error", fo, 0, 0, Severity.ERROR);
        errors.add(pythonDefaultError);
        ErrorsCache.setErrors((URL)context.getRootURI(), (Indexable)file, hasErrors ? errors : Collections.emptyList(), (ErrorsCache.Convertor)new PythonErrorConvertor());
    }

    private void setMethods(String content, IndexingSupport is, Indexable file) throws IOException, BadLocationException {
        IndexDocument createDocument = is.createDocument(file);
        PYTHON_METHOD.matcher(content).results().forEach(methodMatch -> {
            String className = " ";
            int startOffset = methodMatch.start(1);
            MatchResult classGroup = PYTHON_CLASS.matcher(content).results().filter(classMatch -> classMatch.end(1) < startOffset).reduce((first, second) -> second).orElse(null);
            if (classGroup != null) {
                className = classGroup.group(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(methodMatch.group(1));
            stringBuilder.append("#");
            stringBuilder.append(methodMatch.start(1));
            stringBuilder.append("#");
            stringBuilder.append(className);
            createDocument.addPair(SYMBOLS_FIELD, stringBuilder.toString(), true, true);
        });
        is.addDocument(createDocument);
    }
}

