/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.indexing;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.python.indexing.PythonCustomIndexer;
import org.openide.filesystems.FileObject;

public class PythonCustomIndexerFactory
extends CustomIndexerFactory {
    public static final Logger LOG = Logger.getLogger(PythonCustomIndexerFactory.class.getName());

    public CustomIndexer createIndexer() {
        return new PythonCustomIndexer();
    }

    public boolean supportsEmbeddedIndexers() {
        return false;
    }

    public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        Project owner;
        FileObject fo = context.getRoot();
        Project project = owner = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
        if (owner != null && owner.getClass().getName().equals("org.netbeans.modules.python.project.PythonProject")) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.log(Level.INFO, () -> "removed " + indexable.getRelativePath());
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }

    public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        Project owner;
        FileObject fo = context.getRoot();
        Project project = owner = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
        if (owner != null && owner.getClass().getName().equals("org.netbeans.modules.python.project.PythonProject")) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.log(Level.INFO, () -> "updated " + indexable.getRelativePath());
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }

    public String getIndexerName() {
        return "PythonIndexer";
    }

    public int getIndexVersion() {
        return 0;
    }
}

