/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.options;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.options.PythonLspServerConfigsOptionsPanelController;
import org.netbeans.modules.python.options.PythonPackagesListRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;

final class PythonLspServerConfigsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static String[] PACKAGES = new String[]{"pylsp", "pyls-isort", "pylsp-mypy", "pylsp-rope", "black", "python-lsp-black", "isort", "pyls-memestra", "ptpython", "ipython", "pytest", "pynguin", "build", "pdoc", "poetry"};
    private final PythonLspServerConfigsOptionsPanelController controller;
    private JEditorPane lspEditorPane;
    private JList lspList;
    private JPanel lspPanel;
    private JLabel lspPythonVersionLabel;
    private JScrollPane lspScrollPane;
    private JCheckBox lspServerCheckBox;
    private JLabel lspServerLabel;
    private JPanel lspSettingsPanel;
    private JScrollPane lspSettingsScrollPane;
    private JSplitPane lspSplitPane;

    PythonLspServerConfigsPanel(final PythonLspServerConfigsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.lspList.setCellRenderer(new PythonPackagesListRenderer());
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.changed();
            }
        };
        this.lspEditorPane.getDocument().addDocumentListener(dl);
    }

    private void initComponents() {
        this.lspSplitPane = new JSplitPane();
        this.lspPanel = new JPanel();
        this.lspServerCheckBox = new JCheckBox();
        this.lspServerLabel = new JLabel();
        this.lspScrollPane = new JScrollPane();
        this.lspList = new JList();
        this.lspPythonVersionLabel = new JLabel();
        this.lspSettingsPanel = new JPanel();
        this.lspSettingsScrollPane = new JScrollPane();
        this.lspEditorPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.lspSplitPane.setDividerSize(1);
        this.lspSplitPane.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.lspServerCheckBox, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspServerCheckBox.text"));
        this.lspServerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PythonLspServerConfigsPanel.this.lspServerCheckBoxStateChanged(evt);
            }
        });
        this.lspServerLabel.setFont(new Font("Segoe UI", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lspServerLabel, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspServerLabel.text"));
        this.lspScrollPane.setViewportView(this.lspList);
        this.lspPythonVersionLabel.setFont(new Font("Segoe UI", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lspPythonVersionLabel, (String)NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspPythonVersionLabel.text"));
        GroupLayout lspPanelLayout = new GroupLayout(this.lspPanel);
        this.lspPanel.setLayout(lspPanelLayout);
        lspPanelLayout.setHorizontalGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lspServerLabel, -1, 204, Short.MAX_VALUE).addComponent(this.lspPythonVersionLabel, -1, 204, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lspServerCheckBox).addComponent(this.lspScrollPane, -2, 204, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        lspPanelLayout.setVerticalGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.lspPythonVersionLabel, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lspServerLabel, -2, 18, -2).addContainerGap()).addGroup(lspPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspServerCheckBox).addGap(59, 59, 59).addComponent(this.lspScrollPane, -1, 330, Short.MAX_VALUE).addContainerGap())));
        this.lspSplitPane.setLeftComponent(this.lspPanel);
        this.lspSettingsScrollPane.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PythonLspServerConfigsPanel.class, (String)"PythonLspServerConfigsPanel.lspSettingsScrollPane.border.title")));
        this.lspSettingsScrollPane.setPreferredSize(new Dimension(10, 942));
        this.lspSettingsScrollPane.setRowHeaderView(null);
        this.lspSettingsScrollPane.setViewportView(null);
        this.lspEditorPane.setContentType("text/x-json");
        this.lspSettingsScrollPane.setViewportView(this.lspEditorPane);
        GroupLayout lspSettingsPanelLayout = new GroupLayout(this.lspSettingsPanel);
        this.lspSettingsPanel.setLayout(lspSettingsPanelLayout);
        lspSettingsPanelLayout.setHorizontalGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 369, Short.MAX_VALUE).addGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspSettingsScrollPane, -1, 357, Short.MAX_VALUE).addContainerGap())));
        lspSettingsPanelLayout.setVerticalGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 421, Short.MAX_VALUE).addGroup(lspSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lspSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lspSettingsScrollPane, -1, 409, Short.MAX_VALUE).addContainerGap())));
        this.lspSplitPane.setRightComponent(this.lspSettingsPanel);
        this.add((Component)this.lspSplitPane, "Center");
    }

    private void lspServerCheckBoxStateChanged(ChangeEvent evt) {
        this.controller.changed();
    }

    void load() {
        try {
            this.lspServerCheckBox.setSelected(NbPreferences.root().getBoolean("autoUpdate", false));
            this.lspServerLabel.setText(String.format("%s%s", "Current Version: ", PythonUtility.getServerVersion()));
            this.lspPythonVersionLabel.setText(String.format("%s%s", "Python Version: ", PythonUtility.getVersion(PythonUtility.getLspPythonExe())));
            String pipListOutput = PythonUtility.getPipList(PythonUtility.getLspPythonExe());
            DefaultListModel<Pair> model = new DefaultListModel<Pair>();
            for (String pipPackage : PACKAGES) {
                if (pipListOutput.contains(pipPackage)) {
                    model.addElement(Pair.of((Object)pipPackage, (Object)true));
                    continue;
                }
                model.addElement(Pair.of((Object)pipPackage, (Object)false));
            }
            this.lspList.setModel(model);
            this.lspEditorPane.setText(Files.readString(PythonUtility.SETTINGS.toPath()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void store() {
        if (this.controller.isChanged()) {
            try {
                String jsonSettings = this.lspEditorPane.getText();
                NbPreferences.root().putBoolean("autoUpdate", this.lspServerCheckBox.isSelected());
                Files.writeString(PythonUtility.SETTINGS.toPath(), (CharSequence)jsonSettings, new OpenOption[0]);
                Gson create = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).create();
                Map settings = (Map)create.fromJson(jsonSettings, new TypeToken<HashMap<String, Object>>(){}.getType());
                if (settings != null) {
                    HashMap<String, Map> paramsObject = new HashMap<String, Map>();
                    NbPreferences.root().putBoolean("auto_pop_completion", settings.getOrDefault("auto_pop_completion", true));
                    settings.remove("auto_pop_completion");
                    paramsObject.put("pylsp", settings);
                    DidChangeConfigurationParams params = new DidChangeConfigurationParams(paramsObject);
                    LSPBindings.getAllBindings().forEach(server -> server.getWorkspaceService().didChangeConfiguration(params));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    boolean valid() {
        return true;
    }
}

