/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.javatuples.Quartet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.options.PythonPackageRepoRenderer;
import org.netbeans.modules.python.options.PythonPackageRepositoryOptionsPanelController;
import org.netbeans.modules.python.packagemanager.PythonPackageManagerTopComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class PythonPackageRepositoryPanel
extends JPanel {
    private final PythonPackageRepositoryOptionsPanelController controller;
    File file;
    private JButton addButton;
    private JLabel loginLabel;
    private JTextField loginTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel passLabel;
    private JPasswordField passPasswordField;
    private JButton removeButton;
    private JPanel repoInfosPanel;
    private JList<Quartet<String, String, String, String>> repoList;
    private JPanel repoListPanel;
    private JScrollPane repoListScrollPane;
    private JSplitPane repoSplitPane;
    private JButton updateButton;
    private JLabel urlLabel;
    private JTextField urlTextField;

    PythonPackageRepositoryPanel(PythonPackageRepositoryOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.repoList.setCellRenderer(new PythonPackageRepoRenderer());
        this.file = PythonUtility.REPOS;
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                Files.writeString(this.file.toPath(), (CharSequence)"[]", new OpenOption[0]);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.repoSplitPane = new JSplitPane();
        this.repoListPanel = new JPanel();
        this.repoListScrollPane = new JScrollPane();
        this.repoList = new JList();
        this.repoInfosPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.loginLabel = new JLabel();
        this.passLabel = new JLabel();
        this.loginTextField = new JTextField();
        this.passPasswordField = new JPasswordField();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.updateButton = new JButton();
        this.repoListPanel.setLayout(new BorderLayout());
        this.repoList.setSelectionMode(0);
        this.repoList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PythonPackageRepositoryPanel.this.repoListValueChanged(evt);
            }
        });
        this.repoListScrollPane.setViewportView(this.repoList);
        this.repoListPanel.add((Component)this.repoListScrollPane, "Center");
        this.repoSplitPane.setLeftComponent(this.repoListPanel);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.nameTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.urlLabel.text"));
        this.urlTextField.setText(NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.urlTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.loginLabel, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.loginLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.passLabel, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.passLabel.text"));
        this.loginTextField.setText(NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.loginTextField.text"));
        this.passPasswordField.setText(NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.passPasswordField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageRepositoryPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageRepositoryPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(PythonPackageRepositoryPanel.class, (String)"PythonPackageRepositoryPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageRepositoryPanel.this.updateButtonActionPerformed(evt);
            }
        });
        GroupLayout repoInfosPanelLayout = new GroupLayout(this.repoInfosPanel);
        this.repoInfosPanel.setLayout(repoInfosPanelLayout);
        repoInfosPanelLayout.setHorizontalGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoInfosPanelLayout.createSequentialGroup().addContainerGap().addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoInfosPanelLayout.createSequentialGroup().addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.urlLabel).addComponent(this.loginLabel).addComponent(this.passLabel)).addGap(18, 18, 18).addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField).addComponent(this.urlTextField).addComponent(this.loginTextField).addComponent(this.passPasswordField))).addGroup(GroupLayout.Alignment.TRAILING, repoInfosPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addContainerGap()));
        repoInfosPanelLayout.setVerticalGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoInfosPanelLayout.createSequentialGroup().addContainerGap().addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginLabel).addComponent(this.loginTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passLabel).addComponent(this.passPasswordField, -2, -1, -2)).addGap(18, 18, 18).addGroup(repoInfosPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.updateButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.repoSplitPane.setRightComponent(this.repoInfosPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 734, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repoSplitPane, -1, 734, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 360, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repoSplitPane, -1, 360, Short.MAX_VALUE)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String name = this.nameTextField.getText();
        String url = this.urlTextField.getText();
        String login = this.loginTextField.getText();
        char[] pass = this.passPasswordField.getPassword();
        if (!name.isEmpty() && !url.isEmpty()) {
            DefaultListModel listModel = (DefaultListModel)this.repoList.getModel();
            listModel.addElement(new Quartet((Object)name, (Object)url, (Object)login, (Object)new String(pass)));
            this.repoList.setModel(listModel);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.repoList.getModel();
        int selectedIndex = this.repoList.getSelectedIndex();
        if (selectedIndex != -1) {
            model.remove(selectedIndex);
        }
    }

    private void repoListValueChanged(ListSelectionEvent evt) {
        if (this.repoList.getSelectedIndex() != -1) {
            this.updateButton.setEnabled(true);
            Quartet<String, String, String, String> repo = this.repoList.getSelectedValue();
            this.nameTextField.setText((String)repo.getValue0());
            this.urlTextField.setText((String)repo.getValue1());
            this.loginTextField.setText((String)repo.getValue2());
            this.passPasswordField.setText((String)repo.getValue3());
        }
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.repoList.getModel();
        int selectedIndex = this.repoList.getSelectedIndex();
        String name = this.nameTextField.getText();
        String url = this.urlTextField.getText();
        if (selectedIndex != -1 && !name.isEmpty() && !url.isEmpty()) {
            model.set(selectedIndex, new Quartet((Object)name, (Object)url, (Object)this.loginTextField.getText(), (Object)new String(this.passPasswordField.getPassword())));
        }
    }

    void load() {
        try {
            JSONArray jsonArray = new JSONArray(Files.readString(this.file.toPath()));
            ListDataListener dl = new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    PythonPackageRepositoryPanel.this.controller.changed();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    PythonPackageRepositoryPanel.this.controller.changed();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    PythonPackageRepositoryPanel.this.controller.changed();
                }
            };
            DefaultListModel<Quartet> listModel = new DefaultListModel<Quartet>();
            listModel.addListDataListener(dl);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String login = jsonObject.getString("login");
                char[] read = Keyring.read((String)login);
                listModel.addElement(new Quartet((Object)jsonObject.getString("name"), (Object)jsonObject.getString("url"), (Object)login, (Object)(login.isEmpty() ? "" : (read != null ? new String(read) : ""))));
            }
            this.repoList.setModel(listModel);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void store() {
        if (this.controller.isChanged()) {
            DefaultListModel model = (DefaultListModel)this.repoList.getModel();
            int size = model.getSize();
            JSONArray jsonArray = new JSONArray(size);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                Quartet elementAt = (Quartet)model.getElementAt(i);
                hashMap.put("name", (String)elementAt.getValue0());
                hashMap.put("url", (String)elementAt.getValue1());
                hashMap.put("login", (String)elementAt.getValue2());
                Keyring.save((String)((String)elementAt.getValue2()), (char[])((String)elementAt.getValue3()).toCharArray(), (String)"Repo pass");
                jsonArray.put((Object)new JSONObject(hashMap));
            }
            try {
                Files.writeString(this.file.toPath(), (CharSequence)jsonArray.toString(), new OpenOption[0]);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            EventQueue.invokeLater(() -> {
                TopComponent findTopComponent = WindowManager.getDefault().findTopComponent("PythonPackageManagerTopComponent");
                if (findTopComponent != null && findTopComponent.isOpened()) {
                    PythonPackageManagerTopComponent.refresh();
                }
            });
        }
    }

    boolean valid() {
        return true;
    }
}

