/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.options;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.javatuples.Triplet;
import org.json.JSONObject;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.options.PythonPlatformListRenderer;
import org.netbeans.modules.python.options.PythonPlatformManager;
import org.netbeans.modules.python.options.PythonPlatformOptionsPanelController;
import org.netbeans.modules.python.projectsample.PythonPoetryPanelVisual;
import org.netbeans.modules.python.projectsample.PythonProjectPanelVisual;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

final class PythonPlatformPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final PythonPlatformOptionsPanelController controller;
    RequestProcessor RP = new RequestProcessor(this.getClass().getName(), 1);
    int defaultIndex = 0;
    private JButton addVariableButton;
    private JButton autoDetectPlatform;
    private JTextField command;
    private JButton deleteButton;
    private JPanel envsPanel;
    private JSplitPane envsSplitPane;
    private JTabbedPane infoTabbedPane;
    private JPanel mainPanel;
    private JButton makePlatformDefault;
    private JButton newPlatform;
    private JLabel platformCommandLabel;
    private JLabel platformLabel;
    private JList platformList;
    private JTextField platformName;
    private JLabel platformNameLabel;
    private JScrollPane platformScrollPane;
    private JButton removePlatform;
    private JCheckBox sysCheckBox;
    private JPanel sysEnvsPanel;
    private JScrollPane sysEnvsScrollPane;
    private JTable sysEnvsTable;
    private JLabel sysPathLabel;
    private JList<String> sysPathList;
    private JPanel sysPathPanel;
    private JScrollPane sysPathScrollPane;
    private JPanel userEnvsPanel;
    private JScrollPane userEnvsScrollPane;
    private JTable userEnvsTable;

    PythonPlatformPanel(PythonPlatformOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.platformList.setCellRenderer(new PythonPlatformListRenderer());
        this.userEnvsTable.getModel().addTableModelListener(tme -> controller.changed());
    }

    private void initComponents() {
        this.platformScrollPane = new JScrollPane();
        this.platformList = new JList();
        this.platformLabel = new JLabel();
        this.newPlatform = new JButton();
        this.removePlatform = new JButton();
        this.autoDetectPlatform = new JButton();
        this.infoTabbedPane = new JTabbedPane();
        this.mainPanel = new JPanel();
        this.platformNameLabel = new JLabel();
        this.platformName = new JTextField();
        this.platformCommandLabel = new JLabel();
        this.command = new JTextField();
        this.sysPathPanel = new JPanel();
        this.sysPathLabel = new JLabel();
        this.sysPathScrollPane = new JScrollPane();
        this.sysPathList = new JList();
        this.envsPanel = new JPanel();
        this.envsSplitPane = new JSplitPane();
        this.userEnvsPanel = new JPanel();
        this.userEnvsScrollPane = new JScrollPane();
        this.userEnvsTable = new JTable();
        this.sysCheckBox = new JCheckBox();
        this.addVariableButton = new JButton();
        this.deleteButton = new JButton();
        this.sysEnvsPanel = new JPanel();
        this.sysEnvsScrollPane = new JScrollPane();
        this.sysEnvsTable = new JTable();
        this.makePlatformDefault = new JButton();
        this.platformList.setSelectionMode(0);
        this.platformList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PythonPlatformPanel.this.platformListValueChanged(evt);
            }
        });
        this.platformScrollPane.setViewportView(this.platformList);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.platformLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newPlatform, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.newPlatform.text"));
        this.newPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.newPlatformActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removePlatform, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.removePlatform.text"));
        this.removePlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.removePlatformActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.autoDetectPlatform, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.autoDetectPlatform.text"));
        this.autoDetectPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.autoDetectPlatformActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.platformNameLabel, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.platformNameLabel.text"));
        this.platformName.setEditable(false);
        this.platformName.setText(NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.platformName.text"));
        Mnemonics.setLocalizedText((JLabel)this.platformCommandLabel, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.platformCommandLabel.text"));
        this.command.setEditable(false);
        this.command.setText(NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.command.text"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(44, 44, 44).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.platformCommandLabel).addComponent(this.platformNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.platformName, -1, 485, Short.MAX_VALUE).addComponent(this.command)).addGap(24, 24, 24)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platformNameLabel).addComponent(this.platformName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platformCommandLabel).addComponent(this.command, -2, -1, -2)).addContainerGap(400, Short.MAX_VALUE)));
        this.infoTabbedPane.addTab(NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.mainPanel.TabConstraints.tabTitle"), this.mainPanel);
        Mnemonics.setLocalizedText((JLabel)this.sysPathLabel, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.sysPathLabel.text"));
        this.sysPathScrollPane.setViewportView(this.sysPathList);
        GroupLayout sysPathPanelLayout = new GroupLayout(this.sysPathPanel);
        this.sysPathPanel.setLayout(sysPathPanelLayout);
        sysPathPanelLayout.setHorizontalGroup(sysPathPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sysPathPanelLayout.createSequentialGroup().addContainerGap().addGroup(sysPathPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysPathScrollPane, -1, 648, Short.MAX_VALUE).addGroup(sysPathPanelLayout.createSequentialGroup().addComponent(this.sysPathLabel, -2, 172, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        sysPathPanelLayout.setVerticalGroup(sysPathPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sysPathPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sysPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sysPathScrollPane, -1, 431, Short.MAX_VALUE).addContainerGap()));
        this.infoTabbedPane.addTab(NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.sysPathPanel.TabConstraints.tabTitle"), this.sysPathPanel);
        this.envsSplitPane.setOrientation(0);
        this.userEnvsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        this.userEnvsScrollPane.setViewportView(this.userEnvsTable);
        this.sysCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.sysCheckBox, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.sysCheckBox.text"));
        this.sysCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.sysCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addVariableButton, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.addVariableButton.text"));
        this.addVariableButton.setMaximumSize(new Dimension(100, 29));
        this.addVariableButton.setMinimumSize(new Dimension(100, 29));
        this.addVariableButton.setPreferredSize(new Dimension(100, 29));
        this.addVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.addVariableButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.deleteButton.text"));
        this.deleteButton.setMaximumSize(new Dimension(100, 29));
        this.deleteButton.setMinimumSize(new Dimension(100, 29));
        this.deleteButton.setPreferredSize(new Dimension(100, 29));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout userEnvsPanelLayout = new GroupLayout(this.userEnvsPanel);
        this.userEnvsPanel.setLayout(userEnvsPanelLayout);
        userEnvsPanelLayout.setHorizontalGroup(userEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userEnvsPanelLayout.createSequentialGroup().addContainerGap().addGroup(userEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userEnvsScrollPane).addGroup(GroupLayout.Alignment.TRAILING, userEnvsPanelLayout.createSequentialGroup().addComponent(this.sysCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 136, Short.MAX_VALUE).addComponent(this.addVariableButton, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteButton, -2, -1, -2))).addContainerGap()));
        userEnvsPanelLayout.setVerticalGroup(userEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userEnvsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.userEnvsScrollPane, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(userEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysCheckBox).addComponent(this.deleteButton, -2, -1, -2).addComponent(this.addVariableButton, -2, -1, -2)).addContainerGap()));
        this.envsSplitPane.setLeftComponent(this.userEnvsPanel);
        this.sysEnvsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sysEnvsScrollPane.setViewportView(this.sysEnvsTable);
        GroupLayout sysEnvsPanelLayout = new GroupLayout(this.sysEnvsPanel);
        this.sysEnvsPanel.setLayout(sysEnvsPanelLayout);
        sysEnvsPanelLayout.setHorizontalGroup(sysEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sysEnvsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sysEnvsScrollPane).addContainerGap()));
        sysEnvsPanelLayout.setVerticalGroup(sysEnvsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sysEnvsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sysEnvsScrollPane, -1, 168, Short.MAX_VALUE).addContainerGap()));
        this.envsSplitPane.setRightComponent(this.sysEnvsPanel);
        GroupLayout envsPanelLayout = new GroupLayout(this.envsPanel);
        this.envsPanel.setLayout(envsPanelLayout);
        envsPanelLayout.setHorizontalGroup(envsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 660, Short.MAX_VALUE).addGroup(envsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(envsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.envsSplitPane).addGap(6, 6, 6))));
        envsPanelLayout.setVerticalGroup(envsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 462, Short.MAX_VALUE).addGroup(envsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(envsPanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.envsSplitPane).addGap(8, 8, 8))));
        this.infoTabbedPane.addTab(NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.envsPanel.TabConstraints.tabTitle"), this.envsPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.makePlatformDefault, (String)NbBundle.getMessage(PythonPlatformPanel.class, (String)"PythonPlatformPanel.makePlatformDefault.text"));
        this.makePlatformDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPlatformPanel.this.makePlatformDefaultActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.platformLabel).addComponent(this.platformScrollPane, -2, 180, -2).addComponent(this.autoDetectPlatform, -1, -1, Short.MAX_VALUE).addComponent(this.makePlatformDefault, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.newPlatform, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removePlatform, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoTabbedPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoTabbedPane).addGroup(layout.createSequentialGroup().addComponent(this.platformLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removePlatform).addComponent(this.newPlatform)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoDetectPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.makePlatformDefault)))));
    }

    private void platformListValueChanged(ListSelectionEvent evt) {
        if (this.platformList.getSelectedIndex() != -1) {
            Triplet py = (Triplet)this.platformList.getSelectedValue();
            this.platformName.setText((String)py.getValue1());
            this.command.setText((String)py.getValue0());
            this.setSysPaths((String)py.getValue0());
        }
    }

    private void newPlatformActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileHidingEnabled(false);
        fc.setFileSelectionMode(0);
        if (fc.showOpenDialog(this) == 0) {
            PythonPlatformManager.insert(fc.getSelectedFile().getAbsolutePath());
            this.reloadDetection();
            this.controller.changed();
        }
    }

    private void removePlatformActionPerformed(ActionEvent evt) {
        int selectedIndex = this.platformList.getSelectedIndex();
        if (selectedIndex != -1) {
            Triplet py = (Triplet)this.platformList.getSelectedValue();
            DefaultListModel model = (DefaultListModel)this.platformList.getModel();
            model.remove(selectedIndex);
            PythonPlatformManager.delete((String)py.getValue0());
            this.reloadDetection();
            this.controller.changed();
        }
    }

    private void autoDetectPlatformActionPerformed(ActionEvent evt) {
        PythonPlatformManager.refresh();
        this.reloadDetection();
    }

    private void reloadDetection() {
        List<Triplet<String, String, Boolean>> pythonExes = PythonPlatformManager.getPythonExes();
        if (!pythonExes.isEmpty()) {
            DefaultListModel<Triplet> listModel = new DefaultListModel<Triplet>();
            for (Triplet<String, String, Boolean> pythonExe : pythonExes) {
                listModel.addElement(Triplet.with((Object)((String)pythonExe.getValue0()), (Object)((String)pythonExe.getValue1()), (Object)((Boolean)pythonExe.getValue2())));
                if (!((Boolean)pythonExe.getValue2()).booleanValue()) continue;
                this.defaultIndex = pythonExes.indexOf(pythonExe);
            }
            this.platformList.setModel(listModel);
            this.controller.changed();
        }
    }

    private void makePlatformDefaultActionPerformed(ActionEvent evt) {
        if (this.platformList.getSelectedIndex() != -1) {
            Triplet py = (Triplet)this.platformList.getSelectedValue();
            PythonPlatformManager.setSelected((String)py.getValue0(), "true");
            this.reloadDetection();
            this.controller.changed();
        }
    }

    private void addVariableButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.userEnvsTable.getModel()).addRow(new Object[]{"", ""});
        this.controller.changed();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.userEnvsTable.getSelectedRow() != -1) {
            ((DefaultTableModel)this.userEnvsTable.getModel()).removeRow(this.userEnvsTable.getSelectedRow());
            this.controller.changed();
        }
    }

    private void sysCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    void load() {
        this.RP.post(() -> {
            PythonPlatformManager.refresh();
            this.reloadDetection();
            DefaultTableModel model1 = (DefaultTableModel)this.sysEnvsTable.getModel();
            model1.setRowCount(0);
            DefaultTableModel model2 = (DefaultTableModel)this.userEnvsTable.getModel();
            model2.setRowCount(0);
            Map<String, String> envs = PythonUtility.getEnvs();
            envs.forEach((key, value) -> ((DefaultTableModel)this.sysEnvsTable.getModel()).addRow(new Object[]{key, value}));
            try {
                PythonUtility.getUserEnvs().forEach((key, value) -> ((DefaultTableModel)this.userEnvsTable.getModel()).addRow(new Object[]{key, value}));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                if (!PythonPlatformManager.getDefault().isEmpty()) {
                    this.platformList.setSelectedIndex(this.defaultIndex);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    void store() {
        if (this.controller.isChanged()) {
            NbPreferences.root().putBoolean("sysEnv", this.sysCheckBox.isSelected());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < this.userEnvsTable.getRowCount(); ++i) {
                Object key = this.userEnvsTable.getValueAt(i, 0);
                Object value = this.userEnvsTable.getValueAt(i, 1);
                hashMap.put(key.toString().trim(), value.toString().trim());
            }
            PythonUtility.insertUserEnvs(new JSONObject(hashMap).toString());
        }
        if (PythonProjectPanelVisual.pythonTextField != null) {
            try {
                PythonProjectPanelVisual.pythonTextField.setText(PythonUtility.getPlatformPythonExe());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (PythonPoetryPanelVisual.pythonTextField != null) {
            try {
                PythonPoetryPanelVisual.pythonTextField.setText(PythonUtility.getPlatformPythonExe());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    boolean valid() {
        return true;
    }

    private void setSysPaths(String value1) {
        try {
            DefaultListModel listModel = new DefaultListModel();
            PythonUtility.getCommandOutput(new String[]{value1, "-c", "import sys; print('\\n'.join(sys.path))"}, null).lines().forEach(string -> listModel.addElement(string));
            this.sysPathList.setModel(listModel);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

