/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.packagemanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.javatuples.Triplet;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.packagemanager.Bundle;
import org.netbeans.modules.python.packagemanager.PythonDataProvider;
import org.netbeans.modules.python.packagemanager.PythonHeaderRenderer;
import org.netbeans.modules.python.packagemanager.PythonPackagesModel;
import org.netbeans.modules.python.packagemanager.PythonTreeWillExpand;
import org.netbeans.modules.python.statusbar.PythonStatusBarPanel;
import org.netbeans.swing.etable.QuickFilter;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.awt.Mnemonics;
import org.openide.awt.QuickSearch;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PythonPackageManagerTopComponent", iconBase="org/netbeans/modules/python/pip.png", persistenceType=0)
public final class PythonPackageManagerTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    static Outline outline;
    static QuickSearch attach;
    static String filterText;
    static final JFXPanel jfxPanel;
    static WebView webView;
    static WebEngine engine;
    ProgressHandle pg;
    RequestProcessor RP = new RequestProcessor(((Object)((Object)this)).getClass().getName(), 3);
    private JPanel browserPanel;
    private JButton installButton;
    private JPanel libsPanel;
    private JSplitPane managerSplitPane;
    private JToolBar managerToolBar;
    private JLabel packageNameLabel;
    private JPanel packagesPanel;
    private JButton repositoryButton;
    private JToggleButton searchToggleButton;
    private JComboBox<String> versionsComboBox;
    private JPanel webActionsPanel;
    private JPanel webPanel;

    public PythonPackageManagerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_PythonPackageManagerTopComponent());
        this.setToolTipText(Bundle.HINT_PythonPackageManagerTopComponent());
    }

    private void initComponents() {
        this.managerSplitPane = new JSplitPane();
        this.packagesPanel = new JPanel();
        this.managerToolBar = new JToolBar();
        this.searchToggleButton = new JToggleButton();
        this.repositoryButton = new JButton();
        this.libsPanel = new JPanel();
        this.webPanel = new JPanel();
        this.webActionsPanel = new JPanel();
        this.versionsComboBox = new JComboBox();
        this.installButton = new JButton();
        this.packageNameLabel = new JLabel();
        this.browserPanel = new JPanel();
        this.managerToolBar.setBorder(null);
        this.managerToolBar.setOrientation(1);
        this.managerToolBar.setRollover(true);
        this.managerToolBar.setMaximumSize(new Dimension(22, 44));
        this.searchToggleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/python/find16.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.searchToggleButton, (String)NbBundle.getMessage(PythonPackageManagerTopComponent.class, (String)"PythonPackageManagerTopComponent.searchToggleButton.text"));
        this.searchToggleButton.setFocusable(false);
        this.searchToggleButton.setHorizontalTextPosition(0);
        this.searchToggleButton.setVerticalTextPosition(3);
        this.searchToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageManagerTopComponent.this.searchToggleButtonActionPerformed(evt);
            }
        });
        this.managerToolBar.add(this.searchToggleButton);
        this.repositoryButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/python/settings.png")));
        this.repositoryButton.setToolTipText(NbBundle.getMessage(PythonPackageManagerTopComponent.class, (String)"PythonPackageManagerTopComponent.repositoryButton.toolTipText"));
        this.repositoryButton.setBorder(new SoftBevelBorder(0));
        this.repositoryButton.setFocusable(false);
        this.repositoryButton.setHorizontalTextPosition(0);
        this.repositoryButton.setText(NbBundle.getMessage(PythonPackageManagerTopComponent.class, (String)"PythonPackageManagerTopComponent.repositoryButton.label"));
        this.repositoryButton.setVerticalTextPosition(3);
        this.repositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageManagerTopComponent.this.repositoryButtonActionPerformed(evt);
            }
        });
        this.managerToolBar.add(this.repositoryButton);
        this.libsPanel.setLayout(new BorderLayout());
        GroupLayout packagesPanelLayout = new GroupLayout(this.packagesPanel);
        this.packagesPanel.setLayout(packagesPanelLayout);
        packagesPanelLayout.setHorizontalGroup(packagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(packagesPanelLayout.createSequentialGroup().addComponent(this.managerToolBar, -2, -1, -2).addGap(6, 6, 6).addComponent(this.libsPanel, -1, -1, Short.MAX_VALUE)));
        packagesPanelLayout.setVerticalGroup(packagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.managerToolBar, -1, 613, Short.MAX_VALUE).addComponent(this.libsPanel, -1, -1, Short.MAX_VALUE));
        this.managerSplitPane.setLeftComponent(this.packagesPanel);
        this.versionsComboBox.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(PythonPackageManagerTopComponent.class, (String)"PythonPackageManagerTopComponent.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonPackageManagerTopComponent.this.installButtonActionPerformed(evt);
            }
        });
        this.packageNameLabel.setFont(new Font("Segoe UI", 1, 18));
        Mnemonics.setLocalizedText((JLabel)this.packageNameLabel, (String)NbBundle.getMessage(PythonPackageManagerTopComponent.class, (String)"PythonPackageManagerTopComponent.packageNameLabel.text"));
        GroupLayout webActionsPanelLayout = new GroupLayout(this.webActionsPanel);
        this.webActionsPanel.setLayout(webActionsPanelLayout);
        webActionsPanelLayout.setHorizontalGroup(webActionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webActionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.packageNameLabel, -1, 147, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionsComboBox, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.installButton).addContainerGap()));
        webActionsPanelLayout.setVerticalGroup(webActionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webActionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(webActionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionsComboBox, -2, -1, -2).addComponent(this.installButton).addComponent(this.packageNameLabel)).addContainerGap()));
        this.browserPanel.setLayout(new BorderLayout());
        GroupLayout webPanelLayout = new GroupLayout(this.webPanel);
        this.webPanel.setLayout(webPanelLayout);
        webPanelLayout.setHorizontalGroup(webPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.webActionsPanel, -1, -1, Short.MAX_VALUE)).addGroup(webPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, webPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.browserPanel, -1, -1, Short.MAX_VALUE))));
        webPanelLayout.setVerticalGroup(webPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webPanelLayout.createSequentialGroup().addComponent(this.webActionsPanel, -2, -1, -2).addGap(0, 0, 0)).addGroup(webPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, webPanelLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.browserPanel, -1, -1, Short.MAX_VALUE))));
        this.managerSplitPane.setRightComponent(this.webPanel);
        this.setLayout(new GridBagLayout());
    }

    private void repositoryButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("PythonOptions/PyRepo");
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        try {
            String text = this.installButton.getText();
            String pyPath = PythonStatusBarPanel.currentPyPath.isEmpty() ? PythonUtility.getPlatformPythonExe() : PythonStatusBarPanel.currentPyPath;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)outline.getValueAt(outline.getSelectedRow(), 0);
            Triplet triNode = (Triplet)node.getUserObject();
            String name = triNode.getValue0().toString();
            switch (text) {
                case "Install": {
                    this.RP.post(() -> {
                        PythonUtility.processExecutor(new String[]{pyPath, "-m", "pip", "install", name + "==" + this.versionsComboBox.getSelectedItem().toString()}, "Installing Package " + name);
                        PythonPackagesModel.loadInstalled(pyPath);
                    });
                    break;
                }
                case "Delete": {
                    this.RP.post(() -> {
                        PythonUtility.processExecutor(new String[]{pyPath, "-m", "pip", "uninstall", "-y", name}, "Deleting Package " + name);
                        PythonPackagesModel.loadInstalled(pyPath);
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void searchToggleButtonActionPerformed(ActionEvent evt) {
        this.setSearchVisible(this.searchToggleButton.isSelected());
    }

    public void componentOpened() {
        this.installButton.setVisible(false);
        this.versionsComboBox.setVisible(false);
        OutlineModel model = PythonPackagesModel.getModel();
        this.buildOutline(model);
        JPanel pnlSearch = new JPanel(new GridBagLayout());
        attach = QuickSearch.attach((JComponent)pnlSearch, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0), (QuickSearch.Callback)new QuickFilterCallback(), (boolean)true);
        pnlSearch.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(pnlSearch, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.managerSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.browserPanel.add((Component)jfxPanel);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            webView = new WebView();
            engine = webView.getEngine();
            engine.setJavaScriptEnabled(true);
            engine.getLoadWorker().totalWorkProperty().addListener((ov, oldState, newState) -> {
                if (newState.intValue() >= 0) {
                    this.pg = ProgressHandle.createHandle((String)"Loading Web Page");
                    this.pg.setInitialDelay(0);
                    this.pg.setDisplayName(engine.getLoadWorker().getTitle());
                    this.pg.start(newState.intValue());
                }
            });
            engine.getLoadWorker().workDoneProperty().addListener((ov, oldState, newState) -> this.pg.progress(engine.getLoadWorker().getMessage(), newState.intValue() >= 0 ? newState.intValue() : 0));
            engine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
                if (newState == Worker.State.CANCELLED || newState == Worker.State.FAILED || newState == Worker.State.SUCCEEDED) {
                    this.pg.finish();
                }
            });
            Scene scene = new Scene((Parent)webView);
            jfxPanel.setScene(scene);
        });
    }

    public static void refresh() {
        OutlineModel model = PythonPackagesModel.getModel();
        outline.setModel((TableModel)model);
        outline.getOutlineModel().getTreePathSupport().addTreeWillExpandListener((TreeWillExpandListener)new PythonTreeWillExpand());
    }

    void setSearchVisible(boolean visible) {
        attach.setAlwaysShown(visible);
        if (visible != this.searchToggleButton.isSelected()) {
            this.searchToggleButton.setSelected(visible);
        }
    }

    private void buildOutline(OutlineModel model) {
        outline = new Outline();
        outline.setRootVisible(false);
        outline.setModel((TableModel)model);
        outline.setRowSorter(null);
        outline.setRenderDataProvider((RenderDataProvider)new PythonDataProvider());
        outline.getTableHeader().setDefaultRenderer(new PythonHeaderRenderer());
        outline.setSelectionMode(0);
        outline.getOutlineModel().getTreePathSupport().addTreeWillExpandListener((TreeWillExpandListener)new PythonTreeWillExpand());
        outline.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)outline.getValueAt(outline.getSelectedRow(), 0);
                if (node == null) {
                    return;
                }
                Triplet triNode = (Triplet)node.getUserObject();
                String name = triNode.getValue0().toString();
                String version = triNode.getValue1().toString();
                String index = triNode.getValue2().toString();
                PythonPackageManagerTopComponent.this.packageNameLabel.setText(name);
                try {
                    PythonPackageManagerTopComponent.this.openDoc(PythonPackageManagerTopComponent.this.getUrl(triNode));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (PythonPackageManagerTopComponent.this.isRoot(name)) {
                    PythonPackageManagerTopComponent.this.installButton.setVisible(false);
                    PythonPackageManagerTopComponent.this.versionsComboBox.setVisible(false);
                    PythonPackageManagerTopComponent.this.installButton.setEnabled(false);
                    PythonPackageManagerTopComponent.this.versionsComboBox.setEnabled(false);
                    return;
                }
                PythonPackageManagerTopComponent.this.installButton.setVisible(true);
                PythonPackageManagerTopComponent.this.versionsComboBox.setVisible(true);
                PythonPackageManagerTopComponent.this.installButton.setEnabled(true);
                PythonPackageManagerTopComponent.this.versionsComboBox.setEnabled(true);
                if (!version.isEmpty()) {
                    PythonPackageManagerTopComponent.this.installButton.setText("Delete");
                    PythonPackageManagerTopComponent.this.versionsComboBox.removeAllItems();
                    PythonPackageManagerTopComponent.this.versionsComboBox.addItem(version);
                    PythonPackageManagerTopComponent.this.versionsComboBox.setEnabled(false);
                } else {
                    try {
                        PythonPackageManagerTopComponent.this.installButton.setText("Install");
                        PythonPackageManagerTopComponent.this.versionsComboBox.removeAllItems();
                        String[] cmd = null;
                        cmd = index.isEmpty() ? new String[]{PythonUtility.getLspPythonExe(), "-m", "pip", "index", "versions", name} : (index.equals("https://pypi.org/project") ? new String[]{PythonUtility.getLspPythonExe(), "-m", "pip", "index", "-i", "https://pypi.org/simple", "versions", name} : new String[]{PythonUtility.getLspPythonExe(), "-m", "pip", "index", "-i", index, "versions", name});
                        String commandOutput = PythonUtility.getCommandOutput(cmd, null);
                        Matcher matcher = PythonUtility.PAC_VERSIONS.matcher(commandOutput);
                        if (matcher.find()) {
                            String[] split;
                            for (String string : split = matcher.group(1).split(",")) {
                                PythonPackageManagerTopComponent.this.versionsComboBox.addItem(string);
                            }
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        outline.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                attach.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.libsPanel.removeAll();
        this.libsPanel.add(new JScrollPane((Component)outline));
    }

    public void componentClosed() {
        attach.detach();
    }

    private void openDoc(String url) {
        Platform.runLater(() -> {
            if (url.contains("http")) {
                engine.load(url);
            } else {
                engine.loadContent(url);
            }
        });
    }

    private String getUrl(Triplet object) throws IOException {
        String url = object.getValue2().toString();
        String name = object.getValue0().toString();
        if (url.isEmpty() && this.isRoot(name)) {
            return PythonPackageManagerTopComponent.noDocFound();
        }
        if (url.isEmpty()) {
            String commandOutput = PythonUtility.getCommandOutput(new String[]{PythonStatusBarPanel.currentPyPath.isEmpty() ? PythonUtility.getPlatformPythonExe() : PythonStatusBarPanel.currentPyPath, "-m", "pip", "show", name}, null);
            Matcher matcher = PythonUtility.HOME_PAGE.matcher(commandOutput);
            if (matcher.find()) {
                return matcher.group(1).strip();
            }
            return PythonPackageManagerTopComponent.noDocFound();
        }
        return object.getValue2().toString() + "/" + name;
    }

    private static String noDocFound() {
        return "<html><body>No documentation found in current repository</body></html>";
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private boolean isRoot(String toString) {
        return StringUtils.equalsAny((CharSequence)toString, (CharSequence[])new CharSequence[]{"Installed", "PyPI", "Loading"}) || StringUtils.equalsAny((CharSequence)toString, (CharSequence[])PythonPackagesModel.userRepos);
    }

    static {
        jfxPanel = new JFXPanel();
        webView = null;
        engine = null;
    }

    private class QuickFilterCallback
    implements QuickSearch.Callback {
        private final QuickFilter filter = aValue -> {
            Triplet node = (Triplet)((DefaultMutableTreeNode)aValue).getUserObject();
            String toString = node.getValue0().toString();
            return toString.contains(filterText) || PythonPackageManagerTopComponent.this.isRoot(toString);
        };

        private QuickFilterCallback() {
        }

        public void quickSearchUpdate(String searchText) {
            if (attach != null && !attach.isAlwaysShown()) {
                PythonPackageManagerTopComponent.this.setSearchVisible(true);
            }
            filterText = searchText;
            EventQueue.invokeLater(() -> outline.setQuickFilter(0, (Object)this.filter));
        }

        public void showNextSelection(boolean forward) {
        }

        public String findMaxPrefix(String prefix) {
            return prefix;
        }

        public void quickSearchConfirmed() {
            EventQueue.invokeLater(() -> outline.requestFocusInWindow());
        }

        public void quickSearchCanceled() {
            EventQueue.invokeLater(() -> {
                outline.unsetQuickFilter();
                outline.requestFocusInWindow();
            });
        }
    }
}

