/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.project;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.python.PythonPrivilegedTemplates;
import org.netbeans.modules.python.PythonSharabilityQuery;
import org.netbeans.modules.python.PythonSources;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.PythonBuild;
import org.netbeans.modules.python.actions.PythonRun;
import org.netbeans.modules.python.coverage.PythonCodeCoverageProvider;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.project.PythonProjectOpenedHook;
import org.netbeans.modules.python.project.PythonProjectProblemProvider;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.netbeans.modules.python.projectproperties.PythonCustomizerProvider;
import org.netbeans.modules.python.testrunner.PythonUnitTestRunner;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class PythonProject
implements Project {
    public static final String PYTHON_ICON = "org/netbeans/modules/python/python-2.png";
    public static final String POETRY = "poetry";
    public static final String PYTHON = "python";
    private final FileObject projectDir;
    private final ProjectState state;
    private Lookup lkp;

    PythonProject(FileObject dir, ProjectState state) {
        this.projectDir = dir;
        this.state = state;
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public Lookup getLookup() {
        if (this.lkp == null) {
            this.lkp = Lookups.fixed((Object[])new Object[]{new PythonInfo(), new PythonProjectOpenedHook(this), new PythonProjectLogicalView(this), new PythonCustomizerProvider(this), new PythonPrivilegedTemplates(), new PythonActionProvider(this), new PythonProjectMoveOrRenameOperation(), new PythonProjectCopyOperation(), new PythonProjectDeleteOperation(this), new PythonSources(this), new PythonSharabilityQuery(), new PythonCodeCoverageProvider(this), new PythonProjectStateHandler(this.state), new PythonProjectProblemProvider(this)});
        }
        return this.lkp;
    }

    class PythonActionProvider
    implements ActionProvider {
        PythonProject project;

        public PythonActionProvider(PythonProject project) {
            this.project = project;
        }

        public String[] getSupportedActions() {
            return new String[]{"rename", "move", "copy", "delete", "run.single", "build", "clean", "test", "test.single", "run", "run.single.method", "debug", "debug.single"};
        }

        public void invokeAction(String string, Lookup lkp) throws IllegalArgumentException {
            switch (string) {
                case "rename": {
                    DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, (String)"");
                    break;
                }
                case "move": {
                    DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
                    break;
                }
                case "copy": {
                    DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
                    break;
                }
                case "delete": {
                    DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
                    break;
                }
                case "run.single": {
                    PythonRun.runAction(this.project, (DataObject)lkp.lookup(DataObject.class), false);
                    break;
                }
                case "run": {
                    try {
                        Properties prop = PythonUtility.getProperties(this.project, false);
                        String get = prop.getProperty("nbproject.run.script");
                        PythonRun.runAction(this.project, get != null ? DataObject.find((FileObject)FileUtil.toFileObject((File)new File(get.toString()))) : DataObject.find((FileObject)PythonProject.this.projectDir.getFileObject("main.py")), false);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
                case "test": {
                    try {
                        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("testsources");
                        if (sourceGroups.length == 0) {
                            return;
                        }
                        new PythonUnitTestRunner().runAllTests(this.project, DataObject.find((FileObject)sourceGroups[0].getRootFolder()));
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
                case "test.single": {
                    new PythonUnitTestRunner().runSingleTest(this.project, (DataObject)lkp.lookup(DataObject.class));
                    break;
                }
                case "build": {
                    PythonBuild.runAction(this.project, PythonProject.this.projectDir);
                    break;
                }
                case "clean": {
                    FileUtils.deleteQuietly((File)FileUtil.toFile((FileObject)PythonProject.this.projectDir).toPath().resolve("dist").toFile());
                    FileUtils.deleteQuietly((File)FileUtil.toFile((FileObject)PythonProject.this.projectDir).toPath().resolve("build").toFile());
                    break;
                }
                case "run.single.method": {
                    new PythonUnitTestRunner().runTestMethod(this.project, (TestMethodController.TestMethod)lkp.lookup(TestMethodController.TestMethod.class));
                    break;
                }
                case "debug": {
                    try {
                        Properties prop = PythonUtility.getProperties(this.project, false);
                        String get = prop.getProperty("nbproject.run.script");
                        PythonDebugger.startDebugger(this.project, get != null ? DataObject.find((FileObject)FileUtil.toFileObject((File)new File(get.toString()))) : DataObject.find((FileObject)PythonProject.this.projectDir.getFileObject("main.py")), true);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
                case "debug.single": {
                    PythonDebugger.startDebugger(this.project, (DataObject)lkp.lookup(DataObject.class), true);
                    break;
                }
            }
        }

        public boolean isActionEnabled(String command, Lookup lookup) throws IllegalArgumentException {
            switch (command) {
                case "rename": {
                    return true;
                }
                case "move": {
                    return true;
                }
                case "copy": {
                    return true;
                }
                case "delete": {
                    return true;
                }
                case "run.single": {
                    FileObject fo = ((DataObject)lookup.lookup(DataObject.class)).getPrimaryFile();
                    return !fo.isFolder() && fo.getMIMEType().equals("text/x-python");
                }
                case "run": {
                    Properties prop = null;
                    try {
                        prop = PythonUtility.getProperties(this.project, false);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return PythonProject.this.projectDir.getFileObject("main.py") != null || prop.getProperty("nbproject.run.script") != null && FileUtil.toFileObject((File)new File(prop.getProperty("nbproject.run.script").toString())) != null;
                }
                case "build": {
                    return PythonProject.this.projectDir.getFileObject("pyproject.toml") != null || PythonProject.this.projectDir.getFileObject("setup.py") != null;
                }
                case "clean": {
                    return PythonProject.this.projectDir.getFileObject("dist") != null;
                }
                case "test": {
                    SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("testsources");
                    return sourceGroups.length > 0 && sourceGroups[0].getRootFolder() != null;
                }
                case "test.single": {
                    FileObject fo1 = ((DataObject)lookup.lookup(DataObject.class)).getPrimaryFile();
                    return !fo1.isFolder() && fo1.getMIMEType().equals("text/x-python");
                }
                case "run.single.method": {
                    return true;
                }
                case "debug": {
                    return true;
                }
                case "debug.single": {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class PythonProjectDeleteOperation
    implements DeleteOperationImplementation {
        private final PythonProject project;

        private PythonProjectDeleteOperation(PythonProject project) {
            this.project = project;
        }

        public List<FileObject> getMetadataFiles() {
            return new ArrayList<FileObject>();
        }

        public List<FileObject> getDataFiles() {
            FileObject[] projectChildren;
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            FileObject projectDirectory = this.project.getProjectDirectory();
            for (FileObject fileObject : projectChildren = projectDirectory.getChildren()) {
                this.addFile(projectDirectory, fileObject.getNameExt(), files);
            }
            return files;
        }

        private void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
            FileObject file = projectDirectory.getFileObject(fileName);
            if (file != null) {
                result.add(file);
            }
        }

        public void notifyDeleting() throws IOException {
        }

        public void notifyDeleted() throws IOException {
        }
    }

    private static final class PythonProjectCopyOperation
    implements CopyOperationImplementation {
        private PythonProjectCopyOperation() {
        }

        public List<FileObject> getMetadataFiles() {
            return new ArrayList<FileObject>();
        }

        public List<FileObject> getDataFiles() {
            return new ArrayList<FileObject>();
        }

        public void notifyCopying() throws IOException {
        }

        public void notifyCopied(Project prjct, File file, String string) throws IOException {
        }
    }

    private static final class PythonProjectMoveOrRenameOperation
    implements MoveOrRenameOperationImplementation {
        private PythonProjectMoveOrRenameOperation() {
        }

        public List<FileObject> getMetadataFiles() {
            return new ArrayList<FileObject>();
        }

        public List<FileObject> getDataFiles() {
            return new ArrayList<FileObject>();
        }

        public void notifyRenaming() throws IOException {
        }

        public void notifyRenamed(String nueName) throws IOException {
        }

        public void notifyMoving() throws IOException {
        }

        public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        }
    }

    class PythonProjectLogicalView
    implements LogicalViewProvider {
        private final PythonProject project;

        public PythonProjectLogicalView(PythonProject project) {
            this.project = project;
        }

        public Node createLogicalView() {
            try {
                FileObject projectDirectory = this.project.getProjectDirectory();
                DataFolder projectFolder = DataFolder.findFolder((FileObject)projectDirectory);
                Node nodeOfProjectFolder = projectFolder.getNodeDelegate();
                return new ProjectNode(nodeOfProjectFolder, this.project);
            }
            catch (DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace((Throwable)donfe);
                return new AbstractNode(Children.LEAF);
            }
        }

        public Node findPath(Node root, Object target) {
            Node[] children;
            Project p = (Project)root.getLookup().lookup(Project.class);
            if (p == null) {
                return null;
            }
            for (Node node : children = root.getChildren().getNodes(true)) {
                FileObject kidFO;
                if (!(target instanceof DataObject) && !(target instanceof FileObject) || (kidFO = (FileObject)node.getLookup().lookup(FileObject.class)) == null) continue;
                FileObject targetFO = null;
                targetFO = target instanceof DataObject ? ((DataObject)target).getPrimaryFile() : (FileObject)target;
                Project owner = FileOwnerQuery.getOwner((FileObject)targetFO);
                if (!p.equals(owner)) {
                    return null;
                }
                if (kidFO == targetFO) {
                    return node;
                }
                if (!FileUtil.isParentOf((FileObject)kidFO, (FileObject)targetFO)) continue;
                String relPath = FileUtil.getRelativePath((FileObject)kidFO, (FileObject)targetFO);
                String[] path = relPath.split("/");
                path[path.length - 1] = targetFO.getName();
                Node found = this.findNode(node, path);
                if (found == null) {
                    path[path.length - 1] = targetFO.getNameExt();
                    found = this.findNode(node, path);
                }
                if (found == null) continue;
                if (this.hasObject(found, target)) {
                    return found;
                }
                Node parent = found.getParentNode();
                Children kids = parent.getChildren();
                for (Node child : children = kids.getNodes()) {
                    if (!this.hasObject(child, target)) continue;
                    return child;
                }
            }
            return null;
        }

        private Node findNode(Node start, String[] path) {
            Node found = null;
            try {
                found = NodeOp.findPath((Node)start, (String[])path);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                // empty catch block
            }
            return found;
        }

        private boolean hasObject(Node node, Object obj) {
            if (obj == null) {
                return false;
            }
            FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                return false;
            }
            if (obj instanceof DataObject) {
                DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                if (dataObject == null) {
                    return false;
                }
                if (dataObject.equals(obj)) {
                    return true;
                }
                return this.hasObject(node, ((DataObject)obj).getPrimaryFile());
            }
            if (obj instanceof FileObject) {
                return obj.equals(fileObject);
            }
            return false;
        }

        private final class ProjectNode
        extends FilterNode {
            final PythonProject project;

            public ProjectNode(Node node, PythonProject project) throws DataObjectNotFoundException {
                super(node, NodeFactorySupport.createCompositeChildren((Project)project, (String)"Projects/org-netbeans-modules-python/Nodes"), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
                this.project = project;
            }

            public Action[] getActions(boolean arg0) {
                return CommonProjectActions.forType((String)"org-netbeans-modules-python");
            }

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)PythonProject.PYTHON_ICON);
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }

            public String getDisplayName() {
                return this.project.getProjectDirectory().getName();
            }

            public String getShortDescription() {
                String string;
                block12: {
                    FileObject projectDirectory = this.project.getProjectDirectory();
                    FileObject fileObject = projectDirectory.getFileObject("pyproject.toml");
                    if (fileObject == null) {
                        return super.getShortDescription();
                    }
                    FileConfig conf = FileConfig.of((File)FileUtil.toFile((FileObject)fileObject));
                    try {
                        conf.load();
                        String loc = "Location: " + Paths.get(projectDirectory.getPath(), new String[0]).toString();
                        String desc = (String)conf.getOrElse("project.description", (Object)"");
                        String pVersion = (String)conf.getOrElse("project.version", (Object)"");
                        String pyVersion = PythonUtility.getVersion(PythonUtility.getProjectPythonExe(projectDirectory));
                        StringBuilder s = new StringBuilder("<html>");
                        s.append(super.getShortDescription());
                        s.append("<br>");
                        s.append(loc);
                        if (!desc.isEmpty()) {
                            s.append("<br>");
                            s.append("Description: ");
                            s.append(desc);
                        }
                        if (!pVersion.isEmpty()) {
                            s.append("<br>");
                            s.append("Project version: ");
                            s.append(pVersion);
                        }
                        if (!pyVersion.isEmpty()) {
                            s.append("<br>");
                            s.append(pyVersion);
                        }
                        string = s.append("</html>").toString();
                        if (conf == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conf != null) {
                                try {
                                    conf.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return super.getShortDescription();
                        }
                    }
                    conf.close();
                }
                return string;
            }
        }
    }

    private final class PythonInfo
    implements ProjectInformation {
        private PythonInfo() {
        }

        public Icon getIcon() {
            return new ImageIcon(ImageUtilities.loadImage((String)PythonProject.PYTHON_ICON));
        }

        public String getName() {
            return PythonProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public Project getProject() {
            return PythonProject.this;
        }
    }
}

