/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.project;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class PythonProjectOpenedHook
extends ProjectOpenedHook {
    private final Project project;
    private final FileObject projectDir;
    private final ClassPath source;

    public PythonProjectOpenedHook(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
        this.source = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{project.getProjectDirectory()});
    }

    protected void projectOpened() {
        PythonUtility.createProperties(this.project);
        IndexingManager.getDefault().refreshIndex(this.projectDir.toURL(), null, false, true);
        try {
            String pythonStdLibPath = PythonUtility.getPythonStdLibPath(PythonUtility.getProjectPythonExe(this.project.getProjectDirectory()));
            File file = new File(pythonStdLibPath);
            if (file.exists()) {
                IndexingManager.getDefault().refreshIndex(Utilities.toURI((File)file).toURL(), null, false, false);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            LSPBindings.ensureServerRunning((Project)this.project, (String)"text/x-python");
            Gson create = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).create();
            Map settings = (Map)create.fromJson(Files.readString(PythonUtility.SETTINGS.toPath()), new TypeToken<HashMap<String, Object>>(){}.getType());
            if (settings != null) {
                HashMap<String, Map> paramsObject = new HashMap<String, Map>();
                settings.remove("auto_pop_completion");
                paramsObject.put("pylsp", settings);
                DidChangeConfigurationParams params = new DidChangeConfigurationParams(paramsObject);
                LSPBindings.getBindingsImpl((Project)this.project, (FileObject)this.projectDir, (String)"text/x-python").getWorkspaceService().didChangeConfiguration(params);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.source});
        if (ProjectProblems.isBroken((Project)this.project)) {
            ProjectProblems.showAlert((Project)this.project);
        }
    }

    protected void projectClosed() {
        GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{this.source});
    }
}

