/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.project;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.Bundle;
import org.netbeans.modules.python.projectproperties.PythonCustomizerProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PythonProjectProblemProvider
implements ProjectProblemsProvider {
    private final Project project;
    public static ProjectProblemsProviderSupport problemsProviderSupport;

    public PythonProjectProblemProvider(Project project) {
        assert (project != null);
        this.project = project;
        problemsProviderSupport = new ProjectProblemsProviderSupport((Object)project);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){
            Collection<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>(3);

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                PythonProjectProblemProvider.this.isLspServerInstalled(this.currentProblems);
                PythonProjectProblemProvider.this.selectVenv(this.currentProblems);
                PythonProjectProblemProvider.this.isVenvDependenciesInstalled(this.currentProblems);
                return this.currentProblems;
            }
        });
    }

    private void isLspServerInstalled(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        try {
            String serverVersion = PythonUtility.getServerVersion();
            if (!serverVersion.startsWith("__main__.py")) {
                currentProblems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.CTL_Server(), (String)Bundle.CTL_ServerNotInstalled(), (ProjectProblemResolver)new LSPServerProblemResolverImpl(this.project)));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void selectVenv(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        try {
            String projectPythonExe = PythonUtility.getProjectPythonExe(this.project.getProjectDirectory());
            if (!(this.project.getProjectDirectory().getFileObject(".venv") == null && this.project.getProjectDirectory().getFileObject("venv") == null || projectPythonExe.contains(".venv"))) {
                currentProblems.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.CTL_Venv(), (String)Bundle.CTL_VenvSelection(), (ProjectProblemResolver)new VENVSelectionProblemResolverImpl(this.project)));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void isVenvDependenciesInstalled(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        try {
            String projectPythonExe = PythonUtility.getProjectPythonExe(this.project.getProjectDirectory());
            if (!projectPythonExe.contains(".venv")) {
                return;
            }
            if (!StringUtils.containsAny((CharSequence)PythonUtility.getPipList(projectPythonExe), (CharSequence[])PythonUtility.VENV_DEPS)) {
                currentProblems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.CTL_Venv(), (String)Bundle.CTL_VenvMissingDeps(), (ProjectProblemResolver)new VENVProblemResolverImpl(this.project)));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class VENVSelectionProblemResolverImpl
    implements ProjectProblemResolver {
        Project p;

        public VENVSelectionProblemResolverImpl(Project p) {
            this.p = p;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(() -> {
                try {
                    ((PythonCustomizerProvider)this.p.getLookup().lookup(PythonCustomizerProvider.class)).showCustomizer();
                }
                catch (Exception e) {
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                }
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            });
            toRet.run();
            return toRet;
        }
    }

    private static class VENVProblemResolverImpl
    implements ProjectProblemResolver {
        Project p;

        public VENVProblemResolverImpl(Project p) {
            this.p = p;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(() -> {
                new RequestProcessor().post(() -> {
                    PythonUtility.venvPackageInstaller(this.p.getProjectDirectory());
                    problemsProviderSupport.fireProblemsChange();
                });
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            });
            toRet.run();
            return toRet;
        }
    }

    private static class LSPServerProblemResolverImpl
    implements ProjectProblemResolver {
        public LSPServerProblemResolverImpl(Project p) {
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(() -> {
                new RequestProcessor().post(() -> {
                    PythonUtility.installLsp(this.getClass().getClassLoader());
                    problemsProviderSupport.fireProblemsChange();
                });
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            });
            toRet.run();
            return toRet;
        }
    }
}

