/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectproperties;

import java.awt.Font;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PythonPdocPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    private JLabel pdocParamsLabel;
    public static JTextField pdocParamsTextField;

    public PythonPdocPanel(PythonProject project) {
        this.initComponents();
        this.project = project;
        pdocParamsTextField.getDocument().addDocumentListener(this);
        this.loadProperties();
    }

    private void initComponents() {
        this.pdocParamsLabel = new JLabel();
        pdocParamsTextField = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonPdocPanel.class, (String)"PythonPdocPanel.border.title"), 0, 0, new Font("Segoe UI", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.pdocParamsLabel, (String)NbBundle.getMessage(PythonPdocPanel.class, (String)"PythonPdocPanel.pdocParamsLabel.text"));
        pdocParamsTextField.setText(NbBundle.getMessage(PythonPdocPanel.class, (String)"PythonPdocPanel.pdocParamsTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pdocParamsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(pdocParamsTextField).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pdocParamsLabel).addComponent(pdocParamsTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadProperties() {
        try {
            Properties prop = PythonUtility.getProperties(this.project, false);
            pdocParamsTextField.setText(prop.getProperty("nbproject.pdoc.params", "-o docs"));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void setProperties(PythonProject project) {
        try {
            Properties prop = PythonUtility.getProperties(project, false);
            prop.setProperty("nbproject.pdoc.params", pdocParamsTextField.getText());
            prop.store(new FileWriter(FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void markChange() {
        ((PythonProjectStateHandler)this.project.getLookup().lookup(PythonProjectStateHandler.class)).mark();
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.markChange();
    }
}

