/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectproperties;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.project.PythonProjectStateHandler;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PythonRunPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    private JLabel paramsLabel;
    private static JTextField paramsTextField;
    private JButton scriptButton;
    private JFileChooser scriptFileChooser;
    private JLabel scriptLabel;
    public static JTextField scriptTextField;

    public PythonRunPanel(PythonProject project) {
        this.initComponents();
        this.project = project;
        paramsTextField.getDocument().addDocumentListener(this);
        this.loadProperties();
    }

    private void initComponents() {
        this.scriptFileChooser = new JFileChooser();
        this.scriptLabel = new JLabel();
        this.paramsLabel = new JLabel();
        scriptTextField = new JTextField();
        paramsTextField = new JTextField();
        this.scriptButton = new JButton();
        this.scriptFileChooser.setDialogType(1);
        this.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.border.title"), 0, 0, new Font("Cantarell", 1, 12)));
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.scriptLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.paramsLabel, (String)NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.paramsLabel.text"));
        scriptTextField.setText(NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.scriptTextField.text"));
        paramsTextField.setText(NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.paramsTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.scriptButton, (String)NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.scriptButton.text"));
        this.scriptButton.setToolTipText(NbBundle.getMessage(PythonRunPanel.class, (String)"PythonRunPanel.scriptButton.toolTipText"));
        this.scriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonRunPanel.this.scriptButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paramsLabel).addComponent(this.scriptLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(scriptTextField, -1, 286, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptButton)).addComponent(paramsTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptLabel).addComponent(scriptTextField, -2, -1, -2).addComponent(this.scriptButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paramsLabel).addComponent(paramsTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void scriptButtonActionPerformed(ActionEvent evt) {
        this.scriptFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        int returnValue = this.scriptFileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            scriptTextField.setText(this.scriptFileChooser.getSelectedFile().toPath().toString());
            this.markChange();
        }
    }

    private void loadProperties() {
        try {
            Properties prop = PythonUtility.getProperties(this.project, false);
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("main.py");
            scriptTextField.setText(prop.getProperty("nbproject.run.script", fileObject != null ? Paths.get(fileObject.getPath(), new String[0]).toString() : ""));
            paramsTextField.setText(prop.getProperty("nbproject.run.params", ""));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void setProperties(PythonProject project) {
        try {
            Properties prop = PythonUtility.getProperties(project, false);
            prop.setProperty("nbproject.run.script", scriptTextField.getText());
            prop.setProperty("nbproject.run.params", paramsTextField.getText());
            prop.store(new FileWriter(FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void markChange() {
        ((PythonProjectStateHandler)this.project.getLookup().lookup(PythonProjectStateHandler.class)).mark();
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.markChange();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.markChange();
    }
}

