/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectsample;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.projectsample.PythonPoetryWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PythonPoetryWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static PythonPoetryWizardIterator createIterator() {
        return new PythonPoetryWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new PythonPoetryWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(PythonPoetryWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        String python = (String)this.wiz.getProperty("python");
        String name = (String)this.wiz.getProperty("name");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(dirF.getParentFile());
        pb.command(python, "-m", "poetry", "new", name, "--name", name);
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {}, () -> {}, false, true), (String)String.format("Poetry New Project (%s)", name));
        try {
            Integer get = (Integer)service.run().get();
            if (get != 0) {
                return null;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)dir);
        Properties prop = PythonUtility.getProperties(owner, true);
        prop.setProperty("nbproject.python_path", PythonUtility.getPoetryPythonPath(python, owner.getProjectDirectory()));
        prop.store(new FileWriter(FileUtil.toFile((FileObject)owner.getProjectDirectory().getFileObject("nbproject/project.properties"))), null);
        FileObject configFile = FileUtil.getConfigFile((String)"Templates/Python/Python.py");
        DataObject dtemplate = DataObject.find((FileObject)configFile);
        DataObject createFromTemplate = dtemplate.createFromTemplate(DataFolder.findFolder((FileObject)dir), "main.py");
        resultSet.add(createFromTemplate.getPrimaryFile());
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("python", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

