/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.projectsample;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.projectproperties.PythonPlatformCellRenderer;
import org.netbeans.modules.python.projectsample.PythonProjectWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PythonProjectPanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    private static final long serialVersionUID = 1L;
    private final PythonProjectWizardPanel panel;
    RequestProcessor RP = new RequestProcessor(this.getClass().getName(), 1);
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JButton pythonButton;
    private JLabel pythonLabel;
    public static JTextField pythonTextField;
    private JComboBox<String> venvComboBox;
    private JLabel venvLabel;

    public PythonProjectPanelVisual(PythonProjectWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.venvComboBox.setRenderer(new PythonPlatformCellRenderer());
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.venvComboBox = new JComboBox();
        this.venvLabel = new JLabel();
        this.pythonLabel = new JLabel();
        pythonTextField = new JTextField();
        this.pythonButton = new JButton();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.projectNameLabel.text_1"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.projectLocationLabel.text_2"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.browseButton.text_2"));
        this.browseButton.setActionCommand(NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.browseButton.actionCommand_2"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonProjectPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.createdFolderLabel.text_2"));
        this.createdFolderTextField.setEditable(false);
        this.venvComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "venv", "virtualenv"}));
        this.venvComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonProjectPanelVisual.this.venvComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.venvLabel, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.venvLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.pythonLabel, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.pythonLabel.text"));
        pythonTextField.setText(NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.pythonTextField.text"));
        pythonTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.pythonButton, (String)NbBundle.getMessage(PythonProjectPanelVisual.class, (String)"PythonProjectPanelVisual.pythonButton.text"));
        this.pythonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonProjectPanelVisual.this.pythonButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.projectLocationLabel).addComponent(this.createdFolderLabel).addComponent(this.pythonLabel).addComponent(this.venvLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.venvComboBox, 0, -1, Short.MAX_VALUE).addComponent(pythonTextField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.browseButton, -1, -1, Short.MAX_VALUE).addComponent(this.pythonButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pythonLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pythonTextField, -2, -1, -2).addComponent(this.pythonButton))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.venvComboBox, -2, -1, -2).addComponent(this.venvLabel)).addContainerGap(133, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(null);
            chooser.setDialogTitle("Select Project Location");
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void venvComboBoxActionPerformed(ActionEvent evt) {
        this.panel.fireChangeEvent();
    }

    private void pythonButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("PythonOptions/PyPlatform");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File destFolder;
        File projLoc;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Name is not a valid folder name.");
            return false;
        }
        File f = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!f.isDirectory()) {
            String message = "Project Folder is not a valid path.";
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        for (projLoc = destFolder = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder cannot be created.");
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = "Project Folder is not a valid path.";
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder already exists and is not empty.");
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        d.putProperty("virtualmanager", (Object)this.venvComboBox.getSelectedItem().toString().trim());
        d.putProperty("python", (Object)pythonTextField.getText().trim());
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            projectName = "PythonProject";
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
            this.RP.post(() -> {
                try {
                    pythonTextField.setText(PythonUtility.getPlatformPythonExe());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        this.panel.fireChangeEvent();
    }
}

