/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.repl;

import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.UIUtil;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Map;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;

public class PythonTerminalConnector {
    public static TtyConnector createTtyConnector(String type, PythonProject project) {
        try {
            String[] command;
            Map<String, String> envs = PythonUtility.getEnvs();
            if (!UIUtil.isWindows) {
                envs.put("TERM", "xterm-256color");
            }
            if (type.equals("ptpython")) {
                command = new String[]{PythonUtility.getLspPythonExe(), "-m", "ptpython"};
            } else if (type.equals("ipython")) {
                command = new String[]{PythonUtility.getLspPythonExe(), "-m", "IPython"};
            } else if (type.equals("poetry")) {
                command = new String[]{PythonUtility.getProjectPythonExe(project.getProjectDirectory()), "-m", "poetry", "shell"};
            } else {
                String[] osShell = PythonUtility.getOsShell();
                String[] command2 = UIUtil.isWindows ? new String[]{osShell[0]} : (UIUtil.isMac ? new String[]{osShell[0], "--login"} : new String[]{osShell[0]});
                PtyProcessBuilder processBuilder = new PtyProcessBuilder().setCommand(command2).setEnvironment(envs).setConsole(false).setWindowsAnsiColorEnabled(true).setDirectory(Paths.get(project.getProjectDirectory().getPath(), new String[0]).toString());
                PtyProcess process = processBuilder.start();
                PtyProcessTtyConnector loggingPtyProcessTtyConnector = new PtyProcessTtyConnector(process, Charset.forName("UTF-8"));
                loggingPtyProcessTtyConnector.write((String)(UIUtil.isWindows ? Paths.get(project.getProjectDirectory().getPath(), new String[0]).resolve(".venv\\Scripts\\activate.bat").toString() : "source " + Paths.get(project.getProjectDirectory().getPath(), new String[0]).resolve(".venv/bin/activate").toString()));
                loggingPtyProcessTtyConnector.write(new byte[]{process.getEnterKeyCode()});
                return loggingPtyProcessTtyConnector;
            }
            PtyProcessBuilder processBuilder = new PtyProcessBuilder();
            processBuilder.setCommand(command);
            processBuilder.setEnvironment(envs);
            processBuilder.setConsole(false);
            processBuilder.setWindowsAnsiColorEnabled(true);
            if (project != null) {
                processBuilder.setDirectory(Paths.get(project.getProjectDirectory().getPath(), new String[0]).toString());
            }
            PtyProcess process = processBuilder.start();
            return new PtyProcessTtyConnector(process, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

