/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.repl;

import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.repl.Bundle;
import org.netbeans.modules.python.repl.PythonTerminalConnector;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PythonVEnvConsoleActionTopComponent", iconBase="org/netbeans/modules/python/term.png", persistenceType=0)
public final class PythonVEnvConsoleActionTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    PythonProject project;
    String type;
    static JediTermWidget jediTermWidget;
    static TtyConnector ttyConnector;

    public PythonVEnvConsoleActionTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_PythonVEnvConsoleActionTopComponent());
        this.setToolTipText(Bundle.HINT_PythonVEnvConsoleActionTopComponent());
    }

    public PythonVEnvConsoleActionTopComponent(PythonProject project, String type) {
        this.initComponents();
        this.project = project;
        this.type = type;
        this.setName("(.venv) " + project.getProjectDirectory().getName());
        this.setToolTipText(Bundle.HINT_PythonVEnvConsoleActionTopComponent());
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
        SwingUtilities.invokeLater(() -> {
            ProgressHandle pg = ProgressHandle.createHandle((String)Bundle.CTL_Start());
            pg.switchToIndeterminate();
            pg.start();
            pg.progress(Bundle.CTL_Opening());
            this.setLayout(new GridLayout());
            jediTermWidget = new JediTermWidget((SettingsProvider)new DefaultSettingsProvider(){

                public Font getTerminalFont() {
                    return new Font(PythonUtility.getTermFontFam(), PythonUtility.geTermFontSt(), PythonUtility.getTermFontSize());
                }
            });
            jediTermWidget.addListener(tw -> EventQueue.invokeLater(() -> this.close()));
            ttyConnector = PythonTerminalConnector.createTtyConnector(this.type, this.project);
            jediTermWidget.setTtyConnector(ttyConnector);
            jediTermWidget.start();
            this.removeAll();
            this.add((Component)jediTermWidget);
            pg.finish();
        });
    }

    public void componentClosed() {
        ttyConnector.close();
        jediTermWidget.close();
        this.removeAll();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

