/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.source;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.commons.lang3.math.NumberUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.indexing.PythonIndexQuery;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class PythonSymbolProvider
implements SymbolProvider {
    private final AtomicBoolean canceled = new AtomicBoolean();
    private static final Logger LOG = Logger.getLogger(PythonSymbolProvider.class.getName());

    public String name() {
        return "python";
    }

    public String getDisplayName() {
        return "Python Symbols";
    }

    public void computeSymbolNames(SymbolProvider.Context cntxt, SymbolProvider.Result result) {
        String text = cntxt.getText();
        SearchType kind = cntxt.getSearchType();
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        ArrayList<PythonSymbolDescriptor> symbolDescriptors = new ArrayList<PythonSymbolDescriptor>();
        for (Project openProject : openProjects) {
            if (!(openProject instanceof PythonProject)) continue;
            try {
                if (this.canceled.get()) {
                    LOG.fine("Search canceled");
                    return;
                }
                this.computeSymbols(openProject.getProjectDirectory().toURL(), openProject, kind, text, symbolDescriptors);
                String pythonStdLibPath = PythonUtility.getPythonStdLibPath(PythonUtility.getProjectPythonExe(openProject.getProjectDirectory()));
                File file = new File(pythonStdLibPath);
                if (!file.exists()) {
                    return;
                }
                this.computeSymbols(Utilities.toURI((File)file).toURL(), null, kind, text, symbolDescriptors);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        List toJavaList = io.vavr.collection.List.ofAll(symbolDescriptors).distinctBy(PythonSymbolDescriptor::getId).toJavaList();
        result.addResult(toJavaList);
    }

    private void computeSymbols(URL toURL, Project openProject, SearchType kind, String text, List<PythonSymbolDescriptor> typeDescriptors) {
        Collection<? extends IndexResult> types = PythonIndexQuery.searchIndex(toURL, "methods", kind, text);
        for (IndexResult indexResult : types) {
            for (String value : indexResult.getValues("methods")) {
                String[] split = value.toString().split("#");
                typeDescriptors.add(new PythonSymbolDescriptor(split[0], openProject, indexResult.getFile(), NumberUtils.createInteger((String)split[1]), split[2]));
            }
        }
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void cleanup() {
        this.canceled.set(false);
    }

    class PythonSymbolDescriptor
    extends SymbolDescriptor {
        String methodName;
        Project project;
        FileObject fo;
        int offset;
        String className;

        public PythonSymbolDescriptor(String methodName, Project project, FileObject fo, int offset, String className) {
            this.methodName = methodName;
            this.project = project;
            this.fo = fo;
            this.offset = offset;
            this.className = className;
        }

        public Icon getIcon() {
            return PythonUtility.getMethodIcon();
        }

        public String getSymbolName() {
            return this.methodName;
        }

        public String getOwnerName() {
            return this.className;
        }

        public String getProjectName() {
            return this.project == null ? null : ProjectUtils.getInformation((Project)this.project).getName();
        }

        public Icon getProjectIcon() {
            return this.project == null ? null : PythonUtility.getPythonIcon();
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int getOffset() {
            return this.offset;
        }

        public void open() {
            GsfUtilities.open((FileObject)this.fo, (int)this.offset, (String)this.methodName);
        }

        public String getId() {
            return String.format("%s%s%s", this.methodName, Paths.get(this.fo.getPath(), new String[0]).toString(), this.offset);
        }
    }
}

