/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.source;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.commons.lang3.math.NumberUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.indexing.PythonIndexQuery;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class PythonTypeProvider
implements TypeProvider {
    private final AtomicBoolean canceled = new AtomicBoolean();
    private static final Logger LOG = Logger.getLogger(PythonTypeProvider.class.getName());

    public String name() {
        return "python";
    }

    public String getDisplayName() {
        return "Python Types";
    }

    public void computeTypeNames(TypeProvider.Context cntxt, TypeProvider.Result result) {
        String text = cntxt.getText();
        SearchType kind = cntxt.getSearchType();
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        ArrayList<PythonTypeDescriptor> typeDescriptors = new ArrayList<PythonTypeDescriptor>();
        for (Project openProject : openProjects) {
            if (!(openProject instanceof PythonProject)) continue;
            try {
                if (this.canceled.get()) {
                    LOG.fine("Search canceled");
                    return;
                }
                this.computeTypes(openProject.getProjectDirectory().toURL(), openProject, kind, text, typeDescriptors);
                String pythonStdLibPath = PythonUtility.getPythonStdLibPath(PythonUtility.getProjectPythonExe(openProject.getProjectDirectory()));
                File file = new File(pythonStdLibPath);
                if (!file.exists()) {
                    return;
                }
                this.computeTypes(Utilities.toURI((File)file).toURL(), null, kind, text, typeDescriptors);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        List toJavaList = io.vavr.collection.List.ofAll(typeDescriptors).distinctBy(PythonTypeDescriptor::getId).toJavaList();
        result.addResult(toJavaList);
    }

    private void computeTypes(URL toURL, Project openProject, SearchType kind, String text, List<PythonTypeDescriptor> typeDescriptors) {
        Collection<? extends IndexResult> types = PythonIndexQuery.searchIndex(toURL, "classes", kind, text);
        for (IndexResult indexResult : types) {
            for (String value : indexResult.getValues("classes")) {
                String[] split = value.toString().split("#");
                typeDescriptors.add(new PythonTypeDescriptor(split[0], openProject, indexResult.getFile(), NumberUtils.createInteger((String)split[1])));
            }
        }
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void cleanup() {
        this.canceled.set(false);
    }

    class PythonTypeDescriptor
    extends TypeDescriptor {
        String className;
        Project project;
        FileObject fo;
        int offset;

        public PythonTypeDescriptor(String className, Project project, FileObject fo, int offset) {
            this.className = className;
            this.project = project;
            this.fo = fo;
            this.offset = offset;
        }

        public String getSimpleName() {
            return this.className;
        }

        public String getOuterName() {
            return this.className;
        }

        public String getTypeName() {
            return this.className;
        }

        public String getContextName() {
            return this.project != null ? String.format("(%s)", Paths.get(this.project.getProjectDirectory().toURI()).relativize(Paths.get(this.fo.toURI())).toString()) : String.format("(%s)", Paths.get(this.fo.getPath(), new String[0]).toString());
        }

        public Icon getIcon() {
            return PythonUtility.getClassIcon();
        }

        public String getProjectName() {
            return this.project == null ? null : ProjectUtils.getInformation((Project)this.project).getName();
        }

        public Icon getProjectIcon() {
            return this.project == null ? null : PythonUtility.getPythonIcon();
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int getOffset() {
            return this.offset;
        }

        public void open() {
            GsfUtilities.open((FileObject)this.fo, (int)this.offset, (String)this.className);
        }

        public String getId() {
            return String.format("%s%s%s", this.className, Paths.get(this.fo.getPath(), new String[0]).toString(), this.offset);
        }
    }
}

