/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.packagemanager.PythonPackagesModel;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class PythonStatusBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static Lookup.Result<DataObject> res;
    RequestProcessor requestProcessor = new RequestProcessor(this.getClass().getName(), 1);
    public static String currentPyPath;
    LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            PythonStatusBarPanel.this.requestProcessor.execute(() -> {
                Collection c = ((Lookup.Result)ev.getSource()).allInstances();
                if (!c.isEmpty() && c.size() == 1) {
                    try {
                        DataObject dataO = (DataObject)c.iterator().next();
                        FileObject primaryFile = dataO.getPrimaryFile();
                        boolean isPythonFile = !primaryFile.getMIMEType().equals("text/x-python");
                        Project owner = FileOwnerQuery.getOwner((FileObject)primaryFile);
                        if ((!primaryFile.isFolder() && isPythonFile || owner == null || !(owner instanceof PythonProject)) && isPythonFile) {
                            PythonStatusBarPanel.this.setVisible(false);
                            return;
                        }
                        PythonStatusBarPanel.this.setVisible(true);
                        if (owner != null && owner instanceof PythonProject) {
                            String projectPythonExe = PythonUtility.getProjectPythonExe(owner.getProjectDirectory());
                            statusLabel.setText((projectPythonExe.contains(".venv") ? "(.venv) " : "") + PythonUtility.getVersion(projectPythonExe));
                            statusLabel.setToolTipText(projectPythonExe);
                            currentPyPath = projectPythonExe;
                            statusLabel.setHorizontalTextPosition(4);
                        } else {
                            String platformPythonExe = PythonUtility.getPlatformPythonExe();
                            statusLabel.setText(PythonUtility.getVersion(platformPythonExe));
                            statusLabel.setToolTipText(platformPythonExe);
                            currentPyPath = platformPythonExe;
                            statusLabel.setHorizontalTextPosition(4);
                        }
                        EventQueue.invokeLater(() -> {
                            TopComponent findTopComponent = WindowManager.getDefault().findTopComponent("PythonPackageManagerTopComponent");
                            if (findTopComponent != null && findTopComponent.isOpened()) {
                                try {
                                    PythonPackagesModel.loadInstalled(currentPyPath.isEmpty() ? PythonUtility.getPlatformPythonExe() : currentPyPath);
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    };
    private static JLabel statusLabel;
    private JSeparator statusSeparator;

    public PythonStatusBarPanel() {
        this.initComponents();
        res = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
        res.addLookupListener(this.lookupListener);
        try {
            String platformPythonExe = PythonUtility.getPlatformPythonExe();
            statusLabel.setText(PythonUtility.getVersion(platformPythonExe));
            statusLabel.setToolTipText(platformPythonExe);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        statusLabel = new JLabel();
        this.statusSeparator = new JSeparator();
        statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/python/python-2.png")));
        Mnemonics.setLocalizedText((JLabel)statusLabel, (String)NbBundle.getMessage(PythonStatusBarPanel.class, (String)"PythonStatusBarPanel.statusLabel.text"));
        statusLabel.setHorizontalTextPosition(4);
        statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PythonStatusBarPanel.this.statusLabelMouseClicked(evt);
            }
        });
        this.statusSeparator.setOrientation(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.statusSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(statusLabel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusLabel).addComponent(this.statusSeparator));
    }

    private void statusLabelMouseClicked(MouseEvent evt) {
        OptionsDisplayer.getDefault().open("PythonOptions/PyPlatform");
    }

    static {
        currentPyPath = "";
    }
}

