/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.tasklist;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PythonActionItems
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public PythonActionItems() {
        super("Python Hints", "Python Files Hints", null);
    }

    public List<? extends Task> scan(FileObject resource) {
        if (!resource.getExt().equals("py") || StringUtils.containsAny((CharSequence)Paths.get(resource.getPath(), new String[0]).toString(), (CharSequence[])PythonUtility.EXCLUDED_DIRS)) {
            return Collections.EMPTY_LIST;
        }
        AnnotationHolder ah = AnnotationHolder.getInstance((FileObject)resource);
        if (ah == null) {
            return Collections.EMPTY_LIST;
        }
        List errors = ah.getErrors();
        ArrayList tasks = new ArrayList();
        if (errors != null) {
            errors.forEach(error -> {
                try {
                    Task task = Task.create((FileObject)error.getFile(), (String)PythonActionItems.severityToTaskListString(error.getSeverity()), (String)error.getDescription(), (int)(error.getRange().getBegin().getLine() + 1));
                    tasks.add(task);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        return tasks;
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }

    public void attach(FileTaskScanner.Callback callback) {
        if (callback != null) {
            callback.refreshAll();
        }
    }

    public void notifyFinish() {
        super.notifyFinish();
    }

    public void notifyPrepare() {
        super.notifyPrepare();
    }
}

