/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.testrunner;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.ui.annotation.PopupUtil;
import org.netbeans.modules.gsf.testrunner.ui.annotation.SelectActionPopup;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.python.testrunner.Bundle;
import org.netbeans.modules.python.testrunner.PythonTestMethodAnnotation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.awt.StatusDisplayer;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class PythonTestGlyphAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(PythonTestGlyphAction.class.getName());
    private static final Set<String> fixableAnnotations = new HashSet<String>();

    public PythonTestGlyphAction() {
        this.putValue("Name", Bundle.NM_RunGutterAction());
    }

    @Override
    public Object getValue(String key) {
        if ("supported-annotation-types".equals(key)) {
            return fixableAnnotations.toArray(new String[0]);
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Action a;
        int nextAction;
        Map annotationLines;
        TestMethodController.TestMethod testMethod;
        Object source = e.getSource();
        if (!(source instanceof JTextComponent)) {
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_NoTestMethod());
            return;
        }
        JTextComponent comp = (JTextComponent)source;
        Document doc = comp.getDocument();
        int caretPos = comp.getCaretPosition();
        int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)caretPos);
        AnnotationDesc activeAnnotation = ((BaseDocument)doc).getAnnotations().getActiveAnnotation(line);
        if (activeAnnotation != null && fixableAnnotations.contains(activeAnnotation.getAnnotationType()) && (testMethod = (TestMethodController.TestMethod)(annotationLines = (Map)doc.getProperty(PythonTestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY)).get(line)) != null) {
            SingleMethod singleMethod = testMethod.method();
            ArrayList<SelectActionPopup.ActionDescription> actions = new ArrayList<SelectActionPopup.ActionDescription>();
            ActionProvider ap = CommonUtils.getInstance().getActionProvider(singleMethod.getFile());
            if (ap != null) {
                for (String command : new String[]{"run.single.method", "debug.single.method"}) {
                    String displayName = NbBundle.getMessage(PythonTestGlyphAction.class, (String)("DN_" + command), (Object)singleMethod.getMethodName());
                    if (!Arrays.asList(ap.getSupportedActions()).contains(command) || !ap.isActionEnabled(command, Lookups.singleton((Object)testMethod))) continue;
                    actions.add(new SelectActionPopup.ActionDescription(displayName, () -> ap.invokeAction(command, Lookups.singleton((Object)testMethod))));
                }
            }
            if (actions.size() > 1) {
                Point[] p = new Point[1];
                doc.render(() -> {
                    try {
                        int startOffset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
                        p[0] = comp.modelToView(startOffset).getLocation();
                    }
                    catch (BadLocationException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                });
                JumpList.checkAddEntry((JTextComponent)comp);
                SwingUtilities.convertPointToScreen(p[0], comp);
                PopupUtil.showPopup((JComponent)new SelectActionPopup(Bundle.CAP_SelectAction(), actions), (String)Bundle.CAP_SelectAction(), (int)p[0].x, (int)p[0].y, (boolean)true, (int)0);
            } else if (actions.size() == 1) {
                ((SelectActionPopup.ActionDescription)actions.get((int)0)).action.run();
            }
            return;
        }
        Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)source);
        if (actions == null) {
            return;
        }
        for (nextAction = 0; nextAction < actions.length && actions[nextAction] != this; ++nextAction) {
        }
        if (actions.length > ++nextAction && (a = actions[nextAction]) != null && a.isEnabled()) {
            a.actionPerformed(e);
        }
    }

    @Override
    public boolean isEnabled() {
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        return activetc instanceof CloneableEditorSupport.Pane;
    }

    static {
        fixableAnnotations.add("org-netbeans-modules-python-testrunner-runnable-test-annotation");
    }
}

