/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.testrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.coverage.PythonCodeCoverageProvider;
import org.netbeans.modules.python.project.PythonProject;
import org.netbeans.modules.python.testrunner.PythonTestCase;
import org.netbeans.modules.python.testrunner.PythonTestManager;
import org.netbeans.modules.python.testrunner.PythonTestRunner;
import org.netbeans.spi.project.SingleMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class PythonUnitTestRunner
implements PythonTestRunner {
    public static final Logger LOG = Logger.getLogger(PythonUnitTestRunner.class.getName());
    static File testRunner = PythonUtility.TEST_RUNNER;

    @Override
    public void runSingleTest(PythonProject project, DataObject dob) {
        FileObject pfo = project.getProjectDirectory();
        FileObject fo = dob.getPrimaryFile();
        Object[] runParams = PythonTestManager.getTestRunParams(project);
        String runner = runParams[0].toString();
        if (runner.equals("pytest")) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"PyTest not supported at the moment", 1));
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)pfo));
        PythonUtility.manageRunEnvs(pb);
        ArrayList<String> argList = new ArrayList<String>();
        try {
            String projectPythonExe = PythonUtility.getProjectPythonExe(fo);
            argList.add(projectPythonExe);
            this.getCoverageArgs(argList, project);
            argList.add(testRunner.toPath().toString());
            argList.add("-f");
            argList.add(Paths.get(fo.getPath(), new String[0]).toString());
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
            this.runner(project, PythonTestManager.getTestManager(), PythonTestManager.getSession(project, runner), pb, projectPythonExe, testRunner);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void getCoverageArgs(List<String> argList, PythonProject project) {
        String name = "tests";
        if (project != null) {
            SourceGroup[] sourceGroups;
            for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("testsources")) {
                name = sourceGroup.getRootFolder().getName();
            }
        }
        argList.add("-m");
        argList.add("coverage");
        argList.add("run");
        argList.add("--branch");
        PythonCodeCoverageProvider cp = this.getCoverageProvider(project);
        if (cp.isAggregating()) {
            argList.add("--append");
        }
        argList.add("--source=.");
        argList.add(String.format("--omit=%s/**/*.py", name));
    }

    @Override
    public void runAllTests(PythonProject project, DataObject dob) {
        FileObject pfo = project.getProjectDirectory();
        FileObject fo = dob.getPrimaryFile();
        Object[] runParams = PythonTestManager.getTestRunParams(project);
        String runner = runParams[0].toString();
        if (runner.equals("pytest")) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"PyTest not supported at the moment", 1));
            return;
        }
        Object[] params = (String[])runParams[1];
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)pfo));
        PythonUtility.manageRunEnvs(pb);
        ArrayList<String> argList = new ArrayList<String>();
        try {
            String projectPythonExe = PythonUtility.getProjectPythonExe(fo);
            argList.add(projectPythonExe);
            this.getCoverageArgs(argList, project);
            argList.add(testRunner.toPath().toString());
            argList.add("-d");
            argList.add(Paths.get(fo.getPath(), new String[0]).toString());
            argList.add("-p");
            argList.add(params.length == 1 ? params[0] : ((String[])ArrayUtils.subarray((Object[])params, (int)1, (int)params.length))[0]);
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
            this.runner(project, PythonTestManager.getTestManager(), PythonTestManager.getSession(project, runner), pb, projectPythonExe, testRunner);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void runner(PythonProject project, Manager manager, TestSession testSession, final ProcessBuilder pb, final String projectPythonExe, final File testRunner) {
        final ExecutionDescriptor execDescriptor = new ExecutionDescriptor().frontWindow(true).frontWindowOnError(true).showProgress(true).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new PythonTestOutputLine(manager, testSession)).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new PythonOutputLine()).postExecution(() -> {
            manager.sessionFinished(testSession);
            PythonCodeCoverageProvider cp = this.getCoverageProvider(project);
            if (cp.isEnabled()) {
                cp.refresh();
            }
        });
        final ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)execDescriptor, (String)"Test Runner");
        service.run();
        testSession.setRerunHandler(new RerunHandler(){

            public void rerun() {
                service.run();
            }

            public void rerun(Set<Testcase> set) {
                ArrayList<String> argList = new ArrayList<String>();
                ArrayList<String> builder = new ArrayList<String>();
                for (Testcase testcase : set) {
                    String location = testcase.getLocation();
                    String caseName = testcase.getName();
                    String displayName = testcase.getDisplayName();
                    if (caseName != null && !caseName.startsWith("subtest") && !displayName.endsWith(caseName)) {
                        displayName = String.format("%s.%s", displayName, caseName);
                    }
                    if (location == null) continue;
                    argList.clear();
                    String file = location.split("##")[0];
                    Object[] split = displayName.split(" ")[0].split("\\.");
                    CharSequence[] methodName = (String[])ArrayUtils.subarray((Object[])split, (int)(split.length - 2), (int)split.length);
                    argList.add(projectPythonExe);
                    argList.add(testRunner.toPath().toString());
                    argList.add("-m");
                    argList.add(String.join((CharSequence)".", methodName));
                    argList.add("-f");
                    argList.add(file);
                    builder.add(String.join((CharSequence)" ", argList));
                }
                String[] osShell = PythonUtility.getOsShell();
                ArrayList arrayList = new ArrayList(new LinkedHashSet(builder));
                String[] cmd = new String[]{osShell[0], osShell[1], String.join((CharSequence)(Utilities.isUnix() || Utilities.isMac() ? " && " : "&"), arrayList)};
                pb.command(cmd);
                LOG.info(() -> Arrays.toString(cmd));
                ExecutionService service2 = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)execDescriptor, (String)"Test Runner");
                service2.run();
            }

            public boolean enabled(RerunType rt) {
                return true;
            }

            public void addChangeListener(ChangeListener cl) {
            }

            public void removeChangeListener(ChangeListener cl) {
            }
        });
    }

    private PythonCodeCoverageProvider getCoverageProvider(PythonProject project) {
        PythonCodeCoverageProvider cp = (PythonCodeCoverageProvider)project.getLookup().lookup(PythonCodeCoverageProvider.class);
        return cp;
    }

    @Override
    public void runTestMethod(PythonProject project, TestMethodController.TestMethod lookup) {
        try {
            SingleMethod method = lookup.method();
            String testClassName = lookup.getTestClassName();
            FileObject file = method.getFile();
            String projectPythonExe = PythonUtility.getProjectPythonExe(file);
            Object[] runParams = PythonTestManager.getTestRunParams(project);
            String runner = runParams[0].toString();
            if (runner.equals("pytest")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"PyTest not supported at the moment", 1));
                return;
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(FileUtil.toFile((FileObject)project.getProjectDirectory()));
            PythonUtility.manageRunEnvs(pb);
            String methodName = method.getMethodName();
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(projectPythonExe);
            this.getCoverageArgs(argList, project);
            argList.add(testRunner.toPath().toString());
            argList.add("-m");
            argList.add(String.format("%s.%s", testClassName, methodName));
            argList.add("-f");
            argList.add(Paths.get(file.getPath(), new String[0]).toString());
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
            this.runner(project, PythonTestManager.getTestManager(), PythonTestManager.getSession(project, runner), pb, projectPythonExe, testRunner);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static class PythonTestOutputLine
    implements ExecutionDescriptor.LineConvertorFactory {
        Manager manager;
        TestSession testSession;
        TestSuite testSuite;
        static Pattern PATTERN = Pattern.compile("\\%\\s+(time=([0-9.]+))\\s+(testname=([^\\s]+)|subtest=[^\\s]+|[^\\s]+)\\s+\\(([^\\)]+)\\)\\s+(message=|reason=|\\(([^\\)]+)\\))?((test_path=(.*))|(.*)test_path=(.*))|\\%\\s+(time=([0-9.]+))\\s+(testname=([^\\s]+)|subtest=[^\\s]+|[^\\s]+)\\s+(message=|reason=|\\(([^\\)]+)\\))?((test_path=(.*))|(.*)test_path=(.*))");
        LineConvertor LINE_CONVERTOR = line -> {
            Matcher matcher;
            boolean suiteStarted = StringUtils.startsWith((CharSequence)line, (CharSequence)"%SUITE_STARTING%");
            boolean testFailed = StringUtils.startsWith((CharSequence)line, (CharSequence)"%TEST_FAILED%");
            boolean testSkipped = StringUtils.startsWith((CharSequence)line, (CharSequence)"%TEST_SKIPPED%");
            boolean testError = StringUtils.startsWith((CharSequence)line, (CharSequence)"%TEST_ERROR%");
            boolean testFinished = StringUtils.startsWith((CharSequence)line, (CharSequence)"%TEST_FINISHED%");
            boolean suiteFinished = StringUtils.startsWith((CharSequence)line, (CharSequence)"%SUITE_FINISHED%");
            if (suiteStarted) {
                this.testSuite = new TestSuite(line.split(" ")[1]);
                this.testSession.addSuite(this.testSuite);
                this.manager.displaySuiteRunning(this.testSession, this.testSuite);
            }
            if ((matcher = PATTERN.matcher(line)).find()) {
                PythonTestCase pythonTestcase;
                ArrayList<String> list;
                String location;
                long time = (long)Float.parseFloat(matcher.group(14) != null ? matcher.group(14) : matcher.group(2)) * 1000L;
                String methodName = matcher.group(15) != null ? matcher.group(15) : (matcher.group(4) != null ? matcher.group(4) : matcher.group(3));
                String subTest = matcher.group(7);
                String testCaseName = subTest != null ? matcher.group(5) + " " + subTest : matcher.group(5);
                testCaseName = testCaseName == null || testCaseName.isEmpty() || NumberUtils.isDigits((String)testCaseName) ? methodName : testCaseName;
                String message = matcher.group(11) != null ? matcher.group(11) : matcher.group(8);
                String string = location = matcher.group(10) != null ? matcher.group(10) : matcher.group(12);
                if (testFailed) {
                    list = new ArrayList<String>();
                    pythonTestcase = new PythonTestCase(methodName, testCaseName, "", this.testSession);
                    this.testSuite.addTestcase((Testcase)pythonTestcase);
                    pythonTestcase.setStatus(Status.FAILED);
                    pythonTestcase.setTimeMillis(time);
                    list.add(message);
                    pythonTestcase.addOutputLines(list);
                    pythonTestcase.setLocation(location);
                    this.manager.displayOutput(this.testSession, String.join((CharSequence)" ", line.split(" ", 2)[1]), true);
                }
                if (testFinished) {
                    PythonTestCase pythonTestcase2 = new PythonTestCase(methodName, testCaseName, "", this.testSession);
                    this.testSuite.addTestcase((Testcase)pythonTestcase2);
                    pythonTestcase2.setStatus(Status.PASSED);
                    pythonTestcase2.setTimeMillis(time);
                    pythonTestcase2.setLocation(location);
                }
                if (testSkipped) {
                    list = new ArrayList();
                    pythonTestcase = new PythonTestCase(methodName, testCaseName, "", this.testSession);
                    this.testSuite.addTestcase((Testcase)pythonTestcase);
                    pythonTestcase.setStatus(Status.SKIPPED);
                    pythonTestcase.setTimeMillis(time);
                    list.add(message);
                    pythonTestcase.addOutputLines(list);
                    pythonTestcase.setLocation(location);
                }
                if (testError) {
                    list = new ArrayList();
                    pythonTestcase = new PythonTestCase(methodName, testCaseName, "", this.testSession);
                    this.testSuite.addTestcase((Testcase)pythonTestcase);
                    pythonTestcase.setStatus(Status.ERROR);
                    pythonTestcase.setTimeMillis(time);
                    pythonTestcase.setLocation(location);
                    list.add(message);
                    pythonTestcase.addOutputLines(list);
                    this.manager.displayOutput(this.testSession, String.join((CharSequence)" ", line.split(" ", 2)[1]), true);
                }
            }
            if (suiteFinished) {
                Report report = this.testSession.getReport(this.testSession.getSessionResult().getElapsedTime());
                this.manager.displayReport(this.testSession, report, true);
                this.testSession.finishSuite(this.testSuite);
            }
            PythonUtility.noModuleInstalledHandler(line);
            return Collections.singletonList(ConvertedLine.forText((String)line, null));
        };

        public PythonTestOutputLine(Manager manager, TestSession testSession) {
            this.testSession = testSession;
            this.manager = manager;
        }

        public LineConvertor newLineConvertor() {
            return LineConvertors.proxy((LineConvertor[])new LineConvertor[]{this.LINE_CONVERTOR, PythonUtility.FILE_CONVERTOR, PythonUtility.HTTP_CONVERTOR});
        }
    }
}

