/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.python.Bundle;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.options.PythonPlatformManager;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class PythonUtility {
    public static final Logger LOG = Logger.getLogger(PythonUtility.class.getName());
    public static final RequestProcessor RP = new RequestProcessor("Retry RP", 2);
    public static final String PYTHON_MIME_TYPE = "text/x-python";
    public static final File PYLSP_VENV_DIR = Paths.get(System.getProperty("netbeans.user"), new String[0]).resolve(".pythonlsp").toFile();
    public static final Pattern HOME_PAGE = Pattern.compile(".*Home-page:\\s+(.*)");
    public static final Pattern PAC_VERSIONS = Pattern.compile(".*Available versions:\\s+(.*)");
    public static final Pattern NO_MODULE_PATTERN = Pattern.compile("(.*):\\s+No module named\\s([a-z-]+)");
    public static final Pattern POETRY_PYTHON_PATH = Pattern.compile("(.*)\\s+\\(Activated\\)");
    static final Pattern PYTHON_STACKTRACE_PATTERN = Pattern.compile("^  File \"(.+\\.py)\", line (\\d+).*");
    public static final LineConvertor HTTP_CONVERTOR = LineConvertors.httpUrl();
    public static LineConvertors.FileLocator FILE_LOCATOR = filename -> {
        FileObject toFileObject = FileUtil.toFileObject((File)new File(filename.replaceAll("\"", "").strip()));
        return toFileObject != null ? toFileObject : null;
    };
    public static LineConvertor FILE_CONVERTOR = LineConvertors.filePattern((LineConvertors.FileLocator)FILE_LOCATOR, (Pattern)PYTHON_STACKTRACE_PATTERN, null, (int)1, (int)2);
    public static final String[] IMPORTANT_FILES = new String[]{"Dockerfile", "Jenkinsfile", "LICENSE", "md", "setup.py", "pyproject.toml"};
    public static String[] EXCLUDED_DIRS = new String[]{".venv", "venv", "build", "dist", "nbproject", "py_tests", "pynguin-report", "pycache", ".ropeproject", "__pycache__", "poetry.lock", ".coverage.json"};
    public static String[] VENV_DEPS = new String[]{"pytest", "pynguin", "build"};
    public static String[] LSP_DEPS = new String[]{"python-lsp-server[all]", "pyls-isort", "pylsp-mypy", "pylsp-rope", "black", "python-lsp-black", "isort", "pyls-memestra", "ptpython", "ipython", "pytest", "build", "pdoc", "poetry"};
    public static final File SETTINGS = PYLSP_VENV_DIR.toPath().resolve("settings.json").toFile();
    public static final File SETTINGS_SCHEMA = PYLSP_VENV_DIR.toPath().resolve("schema.json").toFile();
    public static final File REPOS = PYLSP_VENV_DIR.toPath().resolve("repos.json").toFile();
    public static final File PLATFORMS = PYLSP_VENV_DIR.toPath().resolve("platforms.json").toFile();
    public static final File ENVS = PYLSP_VENV_DIR.toPath().resolve("envs.json").toFile();
    public static final File TEST_RUNNER = PYLSP_VENV_DIR.toPath().resolve("nb_test_runner.py").toFile();
    public static final File TOML_HANDLER = PYLSP_VENV_DIR.toPath().resolve("toml_handler.py").toFile();
    public static Preferences TERMINAL_PREFS = NbPreferences.root().node("org/netbeans/modules/terminal/nb");

    public static int getTermFontSize() {
        return TERMINAL_PREFS.getInt("term.fontSize", 18);
    }

    public static int geTermFontSt() {
        return TERMINAL_PREFS.getInt("term.fontStyle", 0);
    }

    public static String getTermFontFam() {
        return TERMINAL_PREFS.get("term.fontFamily", "DejaVu Sans Mono");
    }

    public static String getServerVersion() throws IOException {
        String commandOutput = PythonUtility.getCommandOutput(new String[]{PythonUtility.getLspPythonExe(), "-m", "pylsp", "--version"}, null);
        if (!commandOutput.startsWith("__main__.py")) {
            LOG.log(Level.SEVERE, commandOutput);
            return "UNKNOW";
        }
        return commandOutput;
    }

    public static String getCommandOutput(String[] cmd, FileObject projectDir) throws IOException {
        ProcessBuilder p = new ProcessBuilder(cmd);
        if (projectDir != null) {
            p.directory(FileUtil.toFile((FileObject)projectDir));
        }
        return IOUtils.toString((InputStream)p.redirectErrorStream(true).start().getInputStream(), (Charset)StandardCharsets.UTF_8).strip();
    }

    public static String getPythonStdLibPath(String path) throws IOException {
        return PythonUtility.getCommandOutput(new String[]{path, "-c", "import sysconfig; print(sysconfig.get_paths()['stdlib'])"}, null);
    }

    public static String getLspPythonExe() {
        return PythonUtility.normalizeVenvPath(PYLSP_VENV_DIR.toPath());
    }

    public static String getProjectPythonExe(FileObject fileObject) throws IOException {
        FileObject fileObject1;
        Project owner;
        if (fileObject != null && (owner = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (fileObject1 = owner.getProjectDirectory().getFileObject("nbproject/project.properties")) != null) {
            File toFile = FileUtil.toFile((FileObject)fileObject1);
            Properties appProps = new Properties();
            if (toFile != null) {
                appProps.load(new FileInputStream(toFile));
                String property = appProps.getProperty("nbproject.python_path");
                return property == null || property.isBlank() ? (PythonUtility.isPoetry((PythonProject)owner) ? PythonUtility.getPoetryPythonPath(PythonUtility.getLspPythonExe(), owner.getProjectDirectory()) : PythonUtility.getPlatformPythonExe()) : property;
            }
        }
        return PythonUtility.getPlatformPythonExe();
    }

    public static List<Pair<String, String>> getPythonExes() throws IOException {
        ArrayList<Pair<String, String>> versions = new ArrayList<Pair<String, String>>();
        for (String python : new String[]{"python", "python3", "py"}) {
            PythonUtility.getCommandOutput(new String[]{Utilities.isWindows() ? "where" : "which", python}, null).lines().forEach(exe -> {
                try {
                    String vers;
                    String striped = exe.strip();
                    if (PythonUtility.isValidFilePath(striped) && !(vers = PythonUtility.getVersion(striped)).isEmpty()) {
                        versions.add(Pair.of((Object)vers, (Object)striped));
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        return versions;
    }

    private static boolean isValidFilePath(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            return path.isAbsolute() && path.toFile().exists() && Files.isExecutable(path);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] getOsShell() {
        if (Utilities.isWindows()) {
            return new String[]{"cmd.exe", "/c"};
        }
        if (Utilities.isMac() || Utilities.isUnix()) {
            return new String[]{PythonUtility.getEnvs().getOrDefault("SHELL", "/bin/bash"), "-c"};
        }
        return null;
    }

    public static Map<String, String> getEnvs() {
        HashMap envs = Maps.newHashMap(System.getenv());
        return envs;
    }

    public static String getPlatformPythonExe() throws IOException {
        return PythonPlatformManager.getDefault();
    }

    public static ImageIcon getPythonIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/python-2.png", (boolean)false);
    }

    public static ImageIcon getClassIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/Classes.png", (boolean)false);
    }

    public static ImageIcon getMethodIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/methodPublic.png", (boolean)false);
    }

    public static ImageIcon getPytestIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/pytest.png", (boolean)false);
    }

    public static ImageIcon getPackageIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/package16.png", (boolean)false);
    }

    public static ImageIcon getPynguinIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/pynguin.png", (boolean)false);
    }

    public static Properties getProperties(@NonNull Project project, boolean isCreating) throws IOException {
        Properties prop = new Properties();
        if (OpenProjects.getDefault().isProjectOpen(project) || isCreating) {
            File file = PythonUtility.createProperties(project);
            prop.load(new FileInputStream(file));
        }
        return prop;
    }

    public static String getVersion(String projectPythonExe) throws IOException {
        String commandOutput = PythonUtility.getCommandOutput(new String[]{projectPythonExe, "--version"}, null);
        if (!commandOutput.startsWith("Py")) {
            LOG.log(Level.SEVERE, commandOutput);
            return "";
        }
        return commandOutput;
    }

    public static ImageIcon getErrorIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/error-badge.png", (boolean)false);
    }

    public static ImageIcon getPythonPackageIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/python/libraries.png", (boolean)false);
    }

    public static int venvPackageInstaller(FileObject projectDirectory) {
        Object[] cmd = new String[]{PythonUtility.normalizeVenvPath(FileUtil.toFile((FileObject)projectDirectory).toPath()), "-m", "pip", "install"};
        return PythonUtility.processExecutor((String[])ArrayUtils.addAll((Object[])cmd, (Object[])VENV_DEPS), "Installing packages");
    }

    public static String normalizeVenvPath(Path base) {
        return Utilities.isWindows() ? base.resolve(".venv\\Scripts\\python.exe").toString() : base.resolve(".venv/bin/python").toString();
    }

    public static void packageInstaller(String errorLline) {
        Matcher matcher = NO_MODULE_PATTERN.matcher(errorLline);
        while (matcher.find()) {
            String[] cmd = new String[]{matcher.group(1), "-m", "pip", "install", matcher.group(2)};
            PythonUtility.processExecutor(cmd, Bundle.CTL_Install());
        }
    }

    public static int processExecutor(String[] cmd, String message) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd);
            LOG.info(() -> Arrays.toString(cmd));
            ExecutionDescriptor execDescriptor = new ExecutionDescriptor().frontWindowOnError(true).showProgress(true).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new PythonOutputLine()).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new PythonOutputLine());
            ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)execDescriptor, (String)message);
            int waitFor = (Integer)service.run().get();
            return waitFor;
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
    }

    public static int installLsp(ClassLoader cl) {
        try {
            String[] cmd;
            int processExecutor;
            if (!PYLSP_VENV_DIR.exists()) {
                PYLSP_VENV_DIR.mkdir();
                Files.writeString(SETTINGS.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/settings.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(SETTINGS_SCHEMA.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/schema.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(REPOS.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/repos.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(PLATFORMS.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/platforms.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(ENVS.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/envs.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(TEST_RUNNER.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/nb_test_runner.py", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
                Files.writeString(TOML_HANDLER.toPath(), (CharSequence)IOUtils.resourceToString((String)"org/netbeans/modules/python/toml_handler.py", (Charset)StandardCharsets.UTF_8, (ClassLoader)cl), new OpenOption[0]);
            }
            if ((processExecutor = PythonUtility.processExecutor(cmd = new String[]{PythonUtility.getPlatformPythonExe(), "-m", "venv", PYLSP_VENV_DIR.toPath().resolve(".venv").toString()}, Bundle.CTL_CreatePylsp())) != 0) {
                NotificationDisplayer.getDefault().notify(Bundle.CTL_PylspInstallIssue(), (Icon)PythonUtility.getErrorIcon(), Bundle.CTL_PylspRetry(), e -> RP.post(() -> {
                    PythonUtility.processExecutor(cmd, Bundle.CTL_CreatePylsp());
                    PythonUtility.finish();
                }), NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return PythonUtility.finish();
    }

    public static String getPipList(String exe) throws IOException {
        return PythonUtility.getCommandOutput(new String[]{exe, "-m", "pip", "list"}, null);
    }

    public static int finish() {
        Object[] cmd = new String[]{PythonUtility.getLspPythonExe(), "-m", "pip", "install", "--upgrade"};
        return PythonUtility.processExecutor((String[])ArrayUtils.addAll((Object[])cmd, (Object[])LSP_DEPS), Bundle.CTL_InstallDeps());
    }

    public static void noModuleInstalledHandler(String line) {
        Matcher matcher = NO_MODULE_PATTERN.matcher(line);
        if (matcher.find()) {
            String pyPackage = matcher.group(2);
            NotificationDisplayer.getDefault().notify(String.format("%s %s", Bundle.CTL_MissingDeps(), pyPackage), (Icon)PythonUtility.getPythonPackageIcon(), String.format("Install %s", pyPackage), e -> RP.post(() -> PythonUtility.packageInstaller(line)), NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.WARNING);
        }
    }

    public static Map getUserEnvs() throws IOException {
        File envsFile = PythonPlatformManager.getPathFile();
        JSONObject jsonObject = new JSONObject(Files.readString(envsFile.toPath()));
        return jsonObject.toMap();
    }

    public static void insertUserEnvs(String toString) {
        try {
            Files.writeString(PythonPlatformManager.getPathFile().toPath(), (CharSequence)toString, new OpenOption[0]);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static ExecutionDescriptor getExecutorDescriptor(ExecutionDescriptor.LineConvertorFactory convertorFactory, Runnable preExeRunnable, Runnable postRunnable, boolean controllable, boolean select) {
        ExecutionDescriptor execDescriptor = new ExecutionDescriptor().frontWindow(select).frontWindowOnError(select).controllable(controllable).showProgress(true).inputVisible(true).outConvertorFactory(convertorFactory).errConvertorFactory(convertorFactory).preExecution(preExeRunnable).postExecution(postRunnable);
        return execDescriptor;
    }

    public static boolean isRunWithSysEnvs() {
        return NbPreferences.root().getBoolean("sysEnv", true);
    }

    public static void manageRunEnvs(ProcessBuilder pb) {
        try {
            Map<String, String> environment = pb.environment();
            if (!PythonUtility.isRunWithSysEnvs()) {
                environment.clear();
            }
            Map userEnvs = PythonUtility.getUserEnvs();
            environment.putAll(userEnvs);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String getVenv(PythonProject get) {
        try {
            return PythonUtility.getProperties(get, false).getProperty("nbproject.virtualmanager", "venv");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "venv";
        }
    }

    public static String getProjectType(File toFile) {
        try (FileConfig conf = FileConfig.of((File)toFile);){
            conf.load();
            Object get = conf.get("tool.poetry");
            String string = get == null ? "python" : "poetry";
            return string;
        }
    }

    public static boolean isPoetry(PythonProject project) {
        FileObject fileObject = project.getProjectDirectory().getFileObject("pyproject.toml");
        return fileObject != null && PythonUtility.getProjectType(FileUtil.toFile((FileObject)fileObject)).equals("poetry") || project.getProjectDirectory().getFileObject("poetry.lock") != null;
    }

    public static String getPoetryPythonPath(String defaultPython, FileObject projectDir) {
        try {
            String[] cmd = new String[]{defaultPython, "-m", "poetry", "env", "list", "--full-path"};
            Matcher matcher = POETRY_PYTHON_PATH.matcher(PythonUtility.getCommandOutput(cmd, projectDir));
            if (matcher.find()) {
                String endPath = Utilities.isWindows() ? "\\Scripts\\python.exe" : "/bin/python";
                return String.format("%s%s", matcher.group(1), endPath);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return defaultPython;
    }

    public static File createProperties(Project project) {
        File toFile = Paths.get(project.getProjectDirectory().getPath(), new String[0]).resolve("nbproject").resolve("project.properties").toFile();
        if (!toFile.exists()) {
            try {
                FileUtils.createParentDirectories((File)toFile);
                toFile.createNewFile();
                return toFile;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return toFile;
    }
}

