/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PythonBuild {
    public static final Logger LOG = Logger.getLogger(PythonBuild.class.getName());

    public static void runAction(Project owner, FileObject context) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(FileUtil.toFile((FileObject)context));
        PythonUtility.manageRunEnvs(pb);
        try {
            Properties prop;
            String[] params = new String[]{};
            ArrayList<String> argList = new ArrayList<String>();
            if (owner != null && !(prop = PythonUtility.getProperties(owner, false)).getProperty("nbproject.build.params", "").isEmpty()) {
                params = prop.getProperty("nbproject.build.params", "").split(" ");
            }
            List<String> asList1 = null;
            boolean isPoetry = PythonUtility.isPoetry((PythonProject)owner);
            if (owner != null && owner.getProjectDirectory().getFileObject("pyproject.toml") != null && !isPoetry) {
                asList1 = Arrays.asList(PythonUtility.getProjectPythonExe(context), "-m", "build");
            } else if (owner != null && owner.getProjectDirectory().getFileObject("setup.py") != null) {
                asList1 = Arrays.asList(PythonUtility.getProjectPythonExe(context), Paths.get(owner.getProjectDirectory().getFileObject("setup.py").getPath(), new String[0]).toString(), "build");
            } else if (isPoetry) {
                asList1 = Arrays.asList(PythonUtility.getProjectPythonExe(context), "-m", "poetry", "build");
            }
            argList.addAll(asList1);
            argList.addAll(Arrays.asList(params));
            pb.command(argList);
            LOG.info(() -> Arrays.toString(argList.toArray()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
            if (owner != null) {
                FileUtils.deleteQuietly((File)Paths.get(owner.getProjectDirectory().getPath(), new String[0]).resolve("dist").toFile());
                FileUtils.deleteQuietly((File)Paths.get(owner.getProjectDirectory().getPath(), new String[0]).resolve("build").toFile());
            }
            StatusDisplayer.getDefault().setStatusText(Bundle.CTL_BuildStatusMessage());
            LifecycleManager.getDefault().saveAll();
        }, () -> {}, true, true), (String)String.format("%s%s%s", Bundle.CTL_BuildMessage(), context.getName(), ")"));
        service.run();
    }
}

