/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class PythonFixIndentAction
implements ActionListener {
    private final EditorCookie context;

    public PythonFixIndentAction(EditorCookie context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        StyledDocument doc = this.context.getDocument();
        int endOffset = doc.getEndPosition().getOffset();
        NbDocument.runAtomic((StyledDocument)doc, () -> {
            try {
                String fixIndentation = PythonFixIndentAction.fixIndentation(doc.getText(0, endOffset));
                doc.remove(0, endOffset - 1);
                doc.insertString(0, fixIndentation, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    public static String fixIndentation(String pythonCode) {
        Stack<Integer> indentStack = new Stack<Integer>();
        String[] lines = pythonCode.split("\n");
        StringBuilder fixedCode = new StringBuilder();
        int previousIndent = 0;
        for (String line : lines) {
            int currentIndent = line.length() - line.replaceAll("^[\t ]*", "").length();
            if (currentIndent < previousIndent) {
                while (indentStack.size() > 0 && currentIndent < (Integer)indentStack.peek()) {
                    indentStack.pop();
                }
            }
            for (int i = 0; i < indentStack.size(); ++i) {
                fixedCode.append("    ");
            }
            fixedCode.append(line.replaceAll("^[\t ]*", "") + "\n");
            if (line.endsWith(":")) {
                indentStack.push(currentIndent + 4);
            }
            previousIndent = currentIndent;
        }
        return fixedCode.toString();
    }
}

