/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class PythonRun {
    public static final Logger LOG = Logger.getLogger(PythonRun.class.getName());

    public static void runAction(Project owner, DataObject context, boolean isDebug) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(owner != null ? FileUtil.toFile((FileObject)owner.getProjectDirectory()) : FileUtil.toFile((FileObject)context.getPrimaryFile().getParent()));
        PythonUtility.manageRunEnvs(pb);
        List<String> argList = PythonRun.getRunArgs(owner, context, isDebug);
        pb.command(argList);
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)PythonUtility.getExecutorDescriptor(new PythonOutputLine(), () -> {
            StatusDisplayer.getDefault().setStatusText(Bundle.CTL_Run());
            LifecycleManager.getDefault().saveAll();
        }, () -> {}, true, true), (String)String.format("%s%s%s", "Run (", context.getPrimaryFile().getNameExt(), ")"));
        service.run();
    }

    public static List<String> getRunArgs(Project owner, DataObject context, boolean isDebug) {
        String[] params = new String[]{};
        ArrayList<String> argList = new ArrayList<String>();
        try {
            Properties prop;
            if (owner != null && !(prop = PythonUtility.getProperties(owner, false)).getProperty("nbproject.run.params", "").isEmpty()) {
                params = prop.getProperty("nbproject.run.params", "").split(" ");
            }
            if (owner != null && PythonUtility.isPoetry((PythonProject)owner) && !isDebug) {
                argList.addAll(Arrays.asList(PythonUtility.getProjectPythonExe(context.getPrimaryFile()), "-m", "poetry", "run", "python", Paths.get(context.getPrimaryFile().getPath(), new String[0]).toString()));
            } else {
                argList.addAll(Arrays.asList(PythonUtility.getProjectPythonExe(context.getPrimaryFile()), Paths.get(context.getPrimaryFile().getPath(), new String[0]).toString()));
            }
            argList.addAll(Arrays.asList(params));
            LOG.info(() -> Arrays.toString(argList.toArray()));
            return argList;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

