/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.actions.Bundle;
import org.netbeans.modules.python.actions.PythonRun;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public final class PythonRunAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private static final long serialVersionUID = 1L;
    private Lookup context;
    Lookup.Result<DataObject> lkpInfo;

    public PythonRunAction() {
        this(Utilities.actionsGlobalContext());
    }

    public PythonRunAction(Lookup context) {
        this.putValue("Name", Bundle.CTL_RunAction());
        this.putValue("hideWhenDisabled", true);
        this.context = context;
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(DataObject.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        Collection allInstances = this.lkpInfo.allInstances();
        if (allInstances.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        FileObject primaryFile = ((DataObject)this.lkpInfo.allInstances().stream().findFirst().get()).getPrimaryFile();
        Project owner = FileOwnerQuery.getOwner((FileObject)primaryFile);
        if (owner != null && owner instanceof PythonProject) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new PythonRunAction(context);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        PythonRun.runAction(null, (DataObject)this.lkpInfo.allInstances().stream().findFirst().get(), false);
    }
}

