/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.coverage;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.text.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.python.PythonOutputLine;
import org.netbeans.modules.python.PythonUtility;
import org.netbeans.modules.python.project.PythonProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PythonCodeCoverageProvider
implements CoverageProvider {
    public static final Logger LOG = Logger.getLogger(PythonCodeCoverageProvider.class.getName());
    boolean enabled;
    boolean aggreg;
    PythonProject project;
    FileObject projectDir;

    public PythonCodeCoverageProvider(PythonProject project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAggregating() {
        return this.aggreg;
    }

    public void setAggregating(boolean bln) {
        this.aggreg = bln;
    }

    public void setEnabled(boolean bln) {
        this.enabled = bln;
    }

    public Set<String> getMimeTypes() {
        return new HashSet<String>(Arrays.asList("text/x-python"));
    }

    public void clear() {
        try {
            String[] cmd = new String[]{PythonUtility.getProjectPythonExe(this.projectDir), "-m", "coverage", "erase"};
            this.coverageExecutor(cmd, "Clear Coverage Results");
            FileObject fileObject = this.projectDir.getFileObject(".coverage.json");
            if (fileObject != null) {
                fileObject.delete();
            }
            this.refresh();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public FileCoverageDetails getDetails(FileObject fo, Document dcmnt) {
        JSONObject report = this.getReport();
        if (report == null) {
            return null;
        }
        String orElse = report.keySet().stream().filter(t -> Paths.get(fo.getPath(), new String[0]).toString().endsWith((String)t)).findFirst().orElse(null);
        if (orElse == null) {
            return null;
        }
        JSONObject jsonObject = report.getJSONObject(orElse);
        int lineCount = jsonObject.getJSONObject("summary").getInt("num_statements");
        int executedLineCount = jsonObject.getJSONObject("summary").getInt("covered_lines");
        JSONArray executedLines = jsonObject.getJSONArray("executed_lines");
        JSONArray missingLines = jsonObject.getJSONArray("missing_lines");
        JSONArray executedBranches = jsonObject.getJSONArray("executed_branches");
        JSONArray missingBranches = jsonObject.getJSONArray("missing_branches");
        FileCoverageSummary fileCoverageSummary = new FileCoverageSummary(this.projectDir.getFileObject(orElse), orElse, lineCount, executedLineCount, 0, 0);
        return new PythonFileCoverageDetails(fo, dcmnt, fileCoverageSummary, executedLines, missingLines, executedBranches, missingBranches);
    }

    public List<FileCoverageSummary> getResults() {
        ArrayList<FileCoverageSummary> coverageList = new ArrayList<FileCoverageSummary>();
        JSONObject report = this.getReport();
        if (report == null) {
            return null;
        }
        report.keySet().stream().forEach(t -> {
            JSONObject jsonObject = report.getJSONObject(t);
            int lineCount = jsonObject.getJSONObject("summary").getInt("num_statements");
            int executedLineCount = jsonObject.getJSONObject("summary").getInt("covered_lines");
            coverageList.add(new FileCoverageSummary(this.projectDir.getFileObject(t), t, lineCount, executedLineCount, 0, 0));
        });
        return coverageList;
    }

    public String getTestAllAction() {
        return null;
    }

    private void coverageExecutor(String[] cmd, String message) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd);
        LOG.info(() -> Arrays.toString(cmd));
        pb.directory(FileUtil.toFile((FileObject)this.projectDir));
        PythonUtility.manageRunEnvs(pb);
        ExecutionDescriptor executorDescriptor = PythonUtility.getExecutorDescriptor(new PythonOutputLine(), null, () -> {}, false, false);
        ExecutionService service = ExecutionService.newService(() -> pb.start(), (ExecutionDescriptor)executorDescriptor, (String)message);
        try {
            service.run().get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void refresh() {
        CoverageManager.INSTANCE.resultsUpdated((Project)this.project, (CoverageProvider)this);
    }

    void collectReport() {
        if (this.isEnabled() && this.projectDir.getFileObject(".coverage") != null) {
            try {
                String[] cmd = new String[]{PythonUtility.getProjectPythonExe(this.projectDir), "-m", "coverage", "json", "--ignore-errors", "-o", ".coverage.json"};
                this.coverageExecutor(cmd, "Collect Coverage");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private JSONObject getReport() {
        this.collectReport();
        FileObject fileObject = this.projectDir.getFileObject(".coverage.json");
        if (fileObject != null) {
            try {
                JSONObject jsonObject = new JSONObject(fileObject.asText());
                return jsonObject.getJSONObject("files");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    class PythonFileCoverageDetails
    implements FileCoverageDetails {
        FileObject fo;
        Document doc;
        FileCoverageSummary summary;
        JSONArray executedLines;
        JSONArray missingLines;
        JSONArray executedBranches;
        JSONArray missingBranches;

        public PythonFileCoverageDetails(FileObject fo, Document doc, FileCoverageSummary summary, JSONArray executedLines, JSONArray missingLines, JSONArray executedBranches, JSONArray missingBranches) {
            this.fo = fo;
            this.doc = doc;
            this.summary = summary;
            this.executedLines = executedLines;
            this.missingLines = missingLines;
            this.executedBranches = executedBranches;
            this.missingBranches = missingBranches;
        }

        public FileObject getFile() {
            return this.fo;
        }

        public int getLineCount() {
            return LineDocumentUtils.getLineCount((LineDocument)((LineDocument)this.doc));
        }

        public boolean hasHitCounts() {
            return false;
        }

        public long lastUpdated() {
            return PythonCodeCoverageProvider.this.projectDir.getFileObject(".coverage.json").lastModified().getTime();
        }

        public FileCoverageSummary getSummary() {
            return this.summary;
        }

        public CoverageType getType(int i) {
            int line = i + 1;
            boolean isExecutedL = this.executedLines.toList().stream().flatMap(t -> Stream.of(t)).anyMatch(y -> y.equals(line));
            boolean isMissingL = this.missingLines.toList().stream().flatMap(t -> Stream.of(t)).anyMatch(y -> y.equals(line));
            boolean isMissingB = this.missingBranches.toList().stream().flatMap(t -> Stream.of((List)t)).anyMatch(y -> y.contains(line));
            if (isMissingL) {
                return CoverageType.NOT_COVERED;
            }
            if (isExecutedL && !isMissingB) {
                return CoverageType.COVERED;
            }
            if (isExecutedL && isMissingB) {
                return CoverageType.PARTIAL;
            }
            return CoverageType.UNKNOWN;
        }

        public int getHitCount(int i) {
            return this.summary.getExecutedLineCount();
        }
    }
}

