/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class PythonDebuggerCallStack
implements DebuggingView.DVFrame {
    String filePath;
    int lineNumber;
    String method;
    private boolean current;

    public PythonDebuggerCallStack(String filePath, int lineNumber, String method) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.method = method;
    }

    public String getName() {
        return this.method;
    }

    public DebuggingView.DVThread getThread() {
        return null;
    }

    public void makeCurrent() {
        this.current = true;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public URI getSourceURI() {
        return Paths.get(this.filePath, new String[0]).toUri();
    }

    public int getLine() {
        return this.lineNumber;
    }

    public int getColumn() {
        return 0;
    }

    public Line location() {
        try {
            LineCookie lc = (LineCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)Paths.get(this.getSourceURI()).toFile())).getLookup().lookup(LineCookie.class);
            if (lc == null) {
                return null;
            }
            return lc.getLineSet().getOriginal(this.lineNumber - 1);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

