/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.attach;

import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.python.debugger.attach.Processes;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class PythonDebuggerAttachCustomizer
extends JPanel {
    private final ConnectController controller;
    private final ValidityDocumentListener validityDocumentListener = new ValidityDocumentListener();
    private final RequestProcessor RP = new RequestProcessor(PythonDebuggerAttachCustomizer.class.getName(), 2);
    private Processes.ProcessInfo processInfo = null;
    private JLabel attachLabel;
    private JLabel dbgLabel;
    private JTextField dbgTextField;
    private JScrollPane jScrollPane1;
    private JTable processTable;
    RequestProcessor.Task validationTask = new RequestProcessor(PythonDebuggerAttachCustomizer.class).create((Runnable)new FileValidationTask());

    public PythonDebuggerAttachCustomizer() {
        this.controller = new ConnectController();
        this.initComponents();
        this.initNIFile();
        this.initProcesses();
    }

    private void initNIFile() {
        this.RP.post(() -> {
            FileObject currentFO = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (currentFO != null) {
                File currentFile = FileUtil.toFile((FileObject)currentFO);
                if (currentFile != null && currentFile.canExecute()) {
                    String path = currentFile.getAbsolutePath();
                } else {
                    Project project = FileOwnerQuery.getOwner((FileObject)currentFO);
                    if (project != null) {
                        currentFO = project.getProjectDirectory();
                        currentFile = FileUtil.toFile((FileObject)currentFO);
                        String path = currentFile.getAbsolutePath();
                    } else {
                        Object var2_4 = null;
                    }
                }
            }
        });
    }

    private void initProcesses() {
        this.processTable.setSelectionMode(0);
        int spacing = 8;
        this.processTable.setIntercellSpacing(new Dimension(8, 0));
        Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.attachLabel.text", (Object)0L));
        this.RP.post(() -> {
            List<Processes.ProcessInfo> processes = Processes.getAllProcesses();
            int size = processes.size();
            Object[][] processValues = new Object[size][];
            for (int i = 0; i < size; ++i) {
                Processes.ProcessInfo info = processes.get(i);
                processValues[i] = new Object[]{info.getPid(), info.getCommand()};
            }
            SwingUtilities.invokeLater(() -> {
                this.processTable.setModel(new DefaultTableModel(processValues, new String[]{NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.processPID.text"), NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.processCommand.text")}){
                    Class[] types;
                    {
                        this.types = new Class[]{Long.class, String.class};
                    }

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        return this.types[columnIndex];
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }
                });
                if (!processes.isEmpty()) {
                    int width = this.processTable.getGraphics().getFontMetrics().stringWidth(Long.toString(((Processes.ProcessInfo)processes.get(0)).getPid()));
                    this.processTable.getColumnModel().getColumn(0).setPreferredWidth(width += 16);
                    this.processTable.getColumnModel().getColumn(0).setMaxWidth(width);
                    this.processTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
                        int index = this.processTable.getSelectedRow();
                        if (index < 0) {
                            Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.attachLabel.text", (Object)0L));
                            this.processInfo = null;
                        } else {
                            Processes.ProcessInfo info = (Processes.ProcessInfo)processes.get(index);
                            Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.attachLabel.text", (Object)info.getPid()));
                            this.processInfo = info;
                        }
                    });
                }
            });
        });
    }

    private void initComponents() {
        this.dbgLabel = new JLabel();
        this.dbgTextField = new JTextField();
        this.attachLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.dbgLabel.setLabelFor(this.dbgTextField);
        Mnemonics.setLocalizedText((JLabel)this.dbgLabel, (String)NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.dbgLabel.text"));
        this.dbgTextField.setText(NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.dbgTextField.text"));
        this.attachLabel.setLabelFor(this.processTable);
        Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(PythonDebuggerAttachCustomizer.class, (String)"PythonDebuggerAttachCustomizer.attachLabel.text"));
        this.jScrollPane1.setViewportView(this.processTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.dbgLabel).addGap(10, 10, 10).addComponent(this.dbgTextField).addGap(85, 85, 85)).addGroup(layout.createSequentialGroup().addComponent(this.attachLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbgLabel).addComponent(this.dbgTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attachLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 139, Short.MAX_VALUE).addContainerGap()));
    }

    private void checkValid() {
        assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
        this.validationTask.schedule(200);
    }

    Controller getController() {
        return this.controller;
    }

    public class ConnectController
    implements PersistentController {
        private static final String NI_ATTACH_PROPERTIES = "native_image_attach_settings";
        private static final String PROP_DBG = "debugger";
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public String getDisplayName() {
            return "Python";
        }

        public boolean load(Properties props) {
            assert (!SwingUtilities.isEventDispatchThread());
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PythonDebuggerAttachCustomizer.this.dbgTextField.setText(attachProps.getString(ConnectController.PROP_DBG, "PDB"));
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        public void save(Properties props) {
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            if (SwingUtilities.isEventDispatchThread()) {
                this.saveToProps(attachProps);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ConnectController.this.saveToProps(attachProps);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void saveToProps(Properties attachProps) {
            attachProps.setString(PROP_DBG, PythonDebuggerAttachCustomizer.this.dbgTextField.getText());
        }

        public boolean ok() {
            String debuggerCommand = PythonDebuggerAttachCustomizer.this.dbgTextField.getText();
            Processes.ProcessInfo attach2Process = PythonDebuggerAttachCustomizer.this.processInfo;
            PythonDebuggerAttachCustomizer.this.RP.post(() -> DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Not supported at the moment", 1)));
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
            this.firePropertyChange("valid", !valid, valid);
        }

        void setErrorMessage(String msg) {
            this.firePropertyChange("errorNotification", null, msg);
        }

        void setInformationMessage(String msg) {
            this.firePropertyChange("infoNotification", null, msg);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PythonDebuggerAttachCustomizer.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PythonDebuggerAttachCustomizer.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PythonDebuggerAttachCustomizer.this.checkValid();
        }
    }

    private class FileValidationTask
    implements Runnable {
        private FileValidationTask() {
        }

        @Override
        public void run() {
        }
    }
}

