/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.models;

import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.breakpoints.PythonBreakpoint;
import org.netbeans.modules.python.debugger.models.PythonDebuggerBreakpointsListener;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class PythonDebuggerBreakpointModel
implements NodeModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String LINE_BREAKPOINT_PC = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    RequestProcessor RP = new RequestProcessor(this.getClass().getName(), 5);

    public PythonDebuggerBreakpointModel() {
        PythonDebuggerBreakpointsListener.addChangeListener(ce -> this.RP.post(() -> this.fireChanges()));
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof PythonBreakpoint) {
            String nameExt;
            PythonBreakpoint breakpoint = (PythonBreakpoint)((Object)node);
            FileObject fileObject = breakpoint.getFileObject();
            if (fileObject != null) {
                nameExt = fileObject.getNameExt();
            } else {
                File file = new File(breakpoint.getFilePath());
                nameExt = file.getName();
            }
            PythonDebugger debugger = PythonDebuggerBreakpointModel.getDebugger();
            String name = String.format("%s %s:%s", "Line", nameExt, breakpoint.getLineNumber());
            return debugger != null && PythonDebuggerUtils.contains(debugger.getCurrentLine(), breakpoint.getLine()) ? PythonDebuggerUtils.toHTML(name, true, false, null) : name;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof PythonBreakpoint) {
            PythonBreakpoint breakpoint = (PythonBreakpoint)((Object)node);
            if (!((PythonBreakpoint)((Object)node)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            PythonDebugger debugger = PythonDebuggerBreakpointModel.getDebugger();
            if (debugger != null && PythonDebuggerUtils.contains(debugger.getCurrentLine(), breakpoint.getLine())) {
                return LINE_BREAKPOINT_PC;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof PythonBreakpoint) {
            PythonBreakpoint breakpoint = (PythonBreakpoint)((Object)node);
            return String.format("%s %s:%s", "Line", breakpoint.getFilePath(), breakpoint.getLineNumber());
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    private static PythonDebugger getDebugger() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return null;
        }
        return (PythonDebugger)engine.lookupFirst(null, PythonDebugger.class);
    }
}

