/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.models;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.PythonDebuggerCallStack;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.models.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class PythonDebuggerCallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel,
PythonDebugger.StateListener {
    private static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    private static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private static final Object[] NO_STACK = new Object[]{Bundle.CTL_CallStackModel_noStack()};
    private final PythonDebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public PythonDebuggerCallStackModel(ContextProvider contextProvider) {
        this.debugger = (PythonDebugger)contextProvider.lookupFirst(null, PythonDebugger.class);
        this.debugger.addStateListener((PythonDebugger.StateListener)WeakListeners.create(PythonDebugger.StateListener.class, (EventListener)this, (Object)this.debugger));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            List callStacks = this.debugger.getCallStacks();
            if (callStacks == null) {
                return NO_STACK;
            }
            Collections.reverse(callStacks);
            PythonDebuggerUtils.markStacks(callStacks);
            if (!callStacks.isEmpty()) {
                PythonDebuggerCallStack first = (PythonDebuggerCallStack)callStacks.get(0);
                first.makeCurrent();
            }
            return callStacks.toArray(PythonDebuggerCallStack[]::new);
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof PythonDebuggerCallStack) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return 1;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof PythonDebuggerCallStack) {
            PythonDebuggerCallStack frame = (PythonDebuggerCallStack)node;
            String name = String.format("%s:%s", frame.getName(), frame.getLine());
            return frame.isCurrent() ? PythonDebuggerUtils.toHTML(name, true, false, null) : name;
        }
        if (node == "Root") {
            return "Root";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof PythonDebuggerCallStack) {
            PythonDebuggerCallStack frame = (PythonDebuggerCallStack)node;
            return frame.isCurrent() ? CURRENT_CALL_STACK : CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof PythonDebuggerCallStack) {
            PythonDebuggerCallStack frame = (PythonDebuggerCallStack)node;
            return String.format("%s:%s", frame.getSourceURI().toString(), frame.getLine());
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof PythonDebuggerCallStack) {
            Line line = ((PythonDebuggerCallStack)node).location();
            if (line != null) {
                PythonDebuggerUtils.showLine(new Line[]{line});
            }
            ((PythonDebuggerCallStack)node).makeCurrent();
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if ((columnID == null ? "CallStackFrameLocation" == null : columnID.equals("CallStackFrameLocation")) && node instanceof PythonDebuggerCallStack) {
            String sourceName;
            PythonDebuggerCallStack frame = (PythonDebuggerCallStack)node;
            URI sourceURI = frame.getSourceURI();
            if (sourceURI == null) {
                return "";
            }
            try {
                FileObject file = URLMapper.findFileObject((URL)sourceURI.toURL());
                sourceName = file.getPath();
            }
            catch (MalformedURLException ex) {
                sourceName = sourceURI.toString();
            }
            int line = frame.getLine();
            if (line > 0) {
                return sourceName + ":" + line;
            }
            return sourceName + ":?";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == null ? "CallStackFrameLocation" == null : columnID.equals("CallStackFrameLocation")) {
            if (node instanceof PythonDebuggerCallStack) {
                return true;
            }
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    private void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    @Override
    public void suspended(boolean suspended) {
    }

    @Override
    public void finished() {
    }

    @Override
    public void currentThread() {
        this.fireChanges();
    }

    @Override
    public void currentFrame() {
    }
}

