/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.models;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.models.Bundle;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class PythonDebuggerSession
implements TableModelFilter,
Constants {
    private final List<Session> sessionListeners = new ArrayList<Session>();
    private final List<ModelListener> modelListeners = new CopyOnWriteArrayList<ModelListener>();

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Session && PythonDebuggerSession.isPythonSession((Session)node)) {
            if (null == columnID) {
                throw new UnknownTypeException(node);
            }
            switch (columnID) {
                case "SessionState": {
                    return this.getSessionState((Session)node);
                }
                case "SessionLanguage": {
                    return node;
                }
                case "SessionHostName": {
                    return ((Session)node).getLocationName();
                }
            }
            throw new UnknownTypeException(node);
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Session && PythonDebuggerSession.isPythonSession((Session)node)) {
            if (null == columnID) {
                throw new UnknownTypeException(node);
            }
            switch (columnID) {
                case "SessionState": {
                    return true;
                }
                case "SessionLanguage": {
                    return false;
                }
                case "SessionHostName": {
                    return true;
                }
            }
            throw new UnknownTypeException(node);
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    private static boolean isPythonSession(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return false;
        }
        PythonDebugger d = (PythonDebugger)e.lookupFirst(null, PythonDebugger.class);
        return d != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionState(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return Bundle.MSG_Session_State_Starting();
        }
        PythonDebugger d = (PythonDebugger)e.lookupFirst(null, PythonDebugger.class);
        if (d.isFinished()) {
            return Bundle.MSG_Session_State_Finished();
        }
        List<Session> list = this.sessionListeners;
        synchronized (list) {
            if (!this.sessionListeners.contains(s)) {
                SessionStateListener asl = new SessionStateListener(s, d);
                d.addStateListener(asl);
                this.sessionListeners.add(s);
            }
        }
        if (d.isSuspended()) {
            return Bundle.MSG_Session_State_Stopped();
        }
        return Bundle.MSG_Session_State_Running();
    }

    private void fireModelChanged(Object node) {
        ModelEvent.TableValueChanged me = new ModelEvent.TableValueChanged((Object)this, node, "SessionState");
        for (ModelListener ml : this.modelListeners) {
            ml.modelChanged((ModelEvent)me);
        }
    }

    public void addModelListener(ModelListener l) {
        this.modelListeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.modelListeners.remove(l);
    }

    private class SessionStateListener
    implements PythonDebugger.StateListener {
        private final Session s;
        private final PythonDebugger d;

        SessionStateListener(Session s, PythonDebugger d) {
            this.s = s;
            this.d = d;
        }

        @Override
        public void suspended(boolean suspended) {
            PythonDebuggerSession.this.fireModelChanged(this.s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            PythonDebuggerSession.this.fireModelChanged(this.s);
            this.d.removeStateListener(this);
            List<Session> list = PythonDebuggerSession.this.sessionListeners;
            synchronized (list) {
                PythonDebuggerSession.this.sessionListeners.remove(this.s);
            }
        }

        @Override
        public void currentThread() {
        }

        @Override
        public void currentFrame() {
        }
    }
}

