/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.debugger.pdb;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.python.debugger.PythonDebugger;
import org.netbeans.modules.python.debugger.PythonDebuggerCallStack;
import org.netbeans.modules.python.debugger.PythonDebuggerUtils;
import org.netbeans.modules.python.debugger.models.PythonDebuggerBreakpointsListener;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.InputOutput;

public class PdbClient {
    Process process;
    Pattern CALL_STACK = Pattern.compile("^(\\s+|>\\s)(.+\\.py)\\((\\d+)\\)(.*)\\(", 8);
    Pattern CURRENT_PATTERN = Pattern.compile(".*>\\s+(.+\\.py)\\((\\d+)\\)");
    Pattern BREAKPOINT_PATTERN = Pattern.compile(".*(Breakpoint|Disabled breakpoint|Enabled breakpoint|Deleted breakpoint)\\s+(\\d+)\\s+at\\s+(.+\\.py):(\\d+)");
    boolean isStopped = false;
    InputOutput io;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final BufferedReader ioReader;

    public PdbClient(Process process, InputOutput io) {
        this.process = process;
        this.io = io;
        this.writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.ioReader = new BufferedReader(this.io.getIn());
        RequestProcessor.getDefault().post(() -> this.handleIoInput());
    }

    public Process getProcess() {
        return this.process;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public void sendCommand(String cmd) throws IOException {
        this.isStopped = false;
        this.writeToStream(cmd);
    }

    private void writeToStream(String cmd) throws IOException {
        this.writer.write(cmd);
        this.writer.newLine();
        this.writer.flush();
    }

    public boolean sendCommandAndProcessResponse(String cmd) throws IOException {
        this.isStopped = false;
        this.writeToStream(cmd);
        try {
            return this.processResponse(this.getStreamResponse(false));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public Object[] sendBreakpointsCommand(String cmd) throws IOException {
        this.isStopped = false;
        this.writeToStream(cmd);
        try {
            return this.breakPointCommandResponse(this.getStreamResponse(false));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new Object[]{false};
        }
    }

    public List<PythonDebuggerCallStack> sendWhere(String cmd) throws IOException {
        this.isStopped = false;
        this.writeToStream(cmd);
        return this.whereResponse(this.getStreamResponse(false));
    }

    public String sendCommandAndGetResponse(String cmd) throws IOException {
        this.isStopped = false;
        this.writeToStream(cmd);
        return StringUtils.removeEnd((String)this.getStreamResponse(false), (String)"(Pdb)").trim();
    }

    public String getStreamResponse(boolean first) throws IOException {
        StringBuilder content = new StringBuilder();
        int value = this.reader.read();
        while (value != -1) {
            content.append((char)value);
            value = this.reader.read();
            if (!StringUtils.endsWithAny((CharSequence)content.toString(), (CharSequence[])new String[]{"(Pdb) ", "(Pdb)"}) && (!first || !StringUtils.startsWith((CharSequence)content.toString(), (CharSequence)"->"))) continue;
        }
        String toString = content.toString();
        boolean containsAnyIgnoreCase = StringUtils.containsAnyIgnoreCase((CharSequence)toString, (CharSequence[])new String[]{"***", "error", "Traceback"});
        IOColorLines.println((InputOutput)this.io, (CharSequence)toString, (Color)(containsAnyIgnoreCase ? Color.RED : Color.BLACK));
        return toString;
    }

    public Object[] breakPointCommandResponse(String response) {
        MatchResult breakMatcher = this.BREAKPOINT_PATTERN.matcher(response).results().reduce((first, second) -> second).orElse(null);
        if (breakMatcher != null) {
            int id = NumberUtils.toInt((String)breakMatcher.group(2));
            return new Object[]{true, id};
        }
        return new Object[]{false};
    }

    public boolean processResponse(String response) {
        MatchResult matcher = this.CURRENT_PATTERN.matcher(response).results().reduce((first, second) -> second).orElse(null);
        if (matcher != null) {
            PythonDebugger lookupFirst;
            String filePath = matcher.group(1);
            int lineNumber = NumberUtils.toInt((String)matcher.group(2));
            PythonDebuggerBreakpointsListener.firePropertiesChange();
            PythonDebuggerUtils.markCurrent(new Annotatable[]{this.getLine(filePath, lineNumber - 1)});
            this.isStopped = true;
            DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (currentEngine != null && (lookupFirst = (PythonDebugger)currentEngine.lookupFirst(null, PythonDebugger.class)) != null) {
                lookupFirst.fireSessionState();
                lookupFirst.fireCurrentThread();
            }
            return true;
        }
        return false;
    }

    public List<PythonDebuggerCallStack> whereResponse(String response) {
        ArrayList<PythonDebuggerCallStack> stacks = new ArrayList<PythonDebuggerCallStack>();
        this.CALL_STACK.matcher(response).results().forEach(t -> {
            String filePath = t.group(2);
            int lineNumber = NumberUtils.toInt((String)t.group(3));
            String method = t.group(4);
            stacks.add(new PythonDebuggerCallStack(filePath, lineNumber, method));
        });
        return stacks;
    }

    private Annotatable getLine(String filePath, int lineNumber) {
        FileObject fobj = FileUtil.toFileObject((File)Paths.get(filePath, new String[0]).toFile());
        DataObject dobj = null;
        try {
            dobj = DataObject.find((FileObject)fobj);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dobj != null) {
            LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
            if (lc == null) {
                return null;
            }
            Line l = lc.getLineSet().getOriginal(lineNumber);
            return l;
        }
        return null;
    }

    public boolean isFinished() {
        return !this.process.isAlive();
    }

    public boolean isSuspended() {
        return this.isStopped;
    }

    private void handleIoInput() {
        try (BufferedReader bufferedReader = this.ioReader;){
            String line;
            while ((line = this.ioReader.readLine()) != null) {
                this.writeToStream(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

